/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.core.saml.v2.factories;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.XMLGregorianCalendar;
import org.jboss.identity.federation.core.exceptions.ConfigurationException;
import org.jboss.identity.federation.core.saml.v2.factories.JBossSAMLBaseFactory;
import org.jboss.identity.federation.core.saml.v2.factories.SAMLProtocolFactory;
import org.jboss.identity.federation.core.saml.v2.holders.IDPInfoHolder;
import org.jboss.identity.federation.core.saml.v2.holders.IssuerInfoHolder;
import org.jboss.identity.federation.core.saml.v2.holders.SPInfoHolder;
import org.jboss.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.jboss.identity.federation.core.util.JAXBUtil;
import org.jboss.identity.federation.saml.v2.assertion.AssertionType;
import org.jboss.identity.federation.saml.v2.assertion.NameIDType;
import org.jboss.identity.federation.saml.v2.assertion.SubjectConfirmationDataType;
import org.jboss.identity.federation.saml.v2.assertion.SubjectConfirmationType;
import org.jboss.identity.federation.saml.v2.assertion.SubjectType;
import org.jboss.identity.federation.saml.v2.protocol.ResponseType;
import org.jboss.identity.federation.saml.v2.protocol.StatusCodeType;
import org.jboss.identity.federation.saml.v2.protocol.StatusType;
import org.xml.sax.SAXException;

public class JBossSAMLAuthnResponseFactory {
    private static String pkgName = "org.jboss.identity.federation.saml.v2.protocol:org.jboss.identity.xmlsec.w3.xmldsig:org.jboss.identity.xmlsec.w3.xmlenc";
    private static String schemaLocation = "schema/saml/v2/saml-schema-protocol-2.0.xsd";

    public static StatusType createStatusType(String statusCodeURI) {
        StatusCodeType sct = SAMLProtocolFactory.getObjectFactory().createStatusCodeType();
        sct.setValue(statusCodeURI);
        StatusType statusType = SAMLProtocolFactory.getObjectFactory().createStatusType();
        statusType.setStatusCode(sct);
        return statusType;
    }

    public static ResponseType createResponseType() {
        return SAMLProtocolFactory.getObjectFactory().createResponseType();
    }

    public static ResponseType createResponseType(String ID, SPInfoHolder sp, IDPInfoHolder idp, IssuerInfoHolder issuerInfo) throws ConfigurationException {
        String responseDestinationURI = sp.getResponseDestinationURI();
        XMLGregorianCalendar issueInstant = XMLTimeUtil.getIssueInstant();
        AssertionType assertionType = JBossSAMLBaseFactory.createAssertion();
        assertionType.setID("ID_" + JBossSAMLBaseFactory.createUUID());
        assertionType.setVersion(issuerInfo.getSamlVersion());
        assertionType.setIssueInstant(issueInstant);
        assertionType.setIssuer(issuerInfo.getIssuer());
        SubjectType subjectType = JBossSAMLBaseFactory.createSubject();
        NameIDType nameIDType = JBossSAMLBaseFactory.createNameID();
        nameIDType.setFormat(idp.getNameIDFormat());
        nameIDType.setValue(idp.getNameIDFormatValue());
        JAXBElement<NameIDType> jaxbNameIDType = JBossSAMLBaseFactory.createNameID(nameIDType);
        subjectType.getContent().add(jaxbNameIDType);
        SubjectConfirmationType subjectConfirmation = JBossSAMLBaseFactory.createSubjectConfirmation(idp.getSubjectConfirmationMethod());
        SubjectConfirmationDataType subjectConfirmationData = JBossSAMLBaseFactory.createSubjectConfirmationData(sp.getRequestID(), responseDestinationURI, issueInstant);
        subjectConfirmation.setSubjectConfirmationData(subjectConfirmationData);
        JAXBElement<SubjectConfirmationType> jaxbSubjectConfirmationType = JBossSAMLBaseFactory.createSubjectConfirmation(subjectConfirmation);
        subjectType.getContent().add(jaxbSubjectConfirmationType);
        assertionType.setSubject(subjectType);
        ResponseType responseType = JBossSAMLAuthnResponseFactory.createResponseType(ID, issuerInfo, assertionType);
        responseType.setInResponseTo(sp.getRequestID());
        responseType.setDestination(responseDestinationURI);
        return responseType;
    }

    public static ResponseType createResponseType(String ID, IssuerInfoHolder issuerInfo, AssertionType assertionType) throws ConfigurationException {
        ResponseType responseType = SAMLProtocolFactory.getObjectFactory().createResponseType();
        responseType.setVersion(issuerInfo.getSamlVersion());
        responseType.setID(ID);
        NameIDType issuer = issuerInfo.getIssuer();
        responseType.setIssuer(issuer);
        String statusCode = issuerInfo.getStatusCode();
        if (statusCode == null) {
            throw new IllegalArgumentException("issuerInfo missing status code");
        }
        responseType.setStatus(JBossSAMLAuthnResponseFactory.createStatusType(statusCode));
        XMLGregorianCalendar issueInstant = XMLTimeUtil.getIssueInstant();
        responseType.setIssueInstant(issueInstant);
        if (assertionType.getIssueInstant() == null) {
            assertionType.setIssueInstant(issueInstant);
        }
        responseType.getAssertionOrEncryptedAssertion().add(assertionType);
        return responseType;
    }

    public static Marshaller getMarshaller() throws SAXException, JAXBException {
        return JAXBUtil.getMarshaller(pkgName);
    }

    public static Unmarshaller getUnmarshaller() throws JAXBException, SAXException {
        return JAXBUtil.getUnmarshaller(pkgName);
    }

    public static Marshaller getValidatingMarshaller(boolean schemaValidation) throws SAXException, JAXBException {
        if (schemaValidation) {
            return JAXBUtil.getValidatingMarshaller(pkgName, schemaLocation);
        }
        return JAXBUtil.getMarshaller(pkgName);
    }

    public static Unmarshaller getValidatingUnmarshaller() throws JAXBException, SAXException {
        return JAXBUtil.getValidatingUnmarshaller(pkgName, schemaLocation);
    }
}

