/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.core.saml.v2.util;

import java.io.Reader;
import java.io.StringReader;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import org.jboss.identity.federation.core.exceptions.ConfigurationException;
import org.jboss.identity.federation.core.exceptions.ProcessingException;
import org.jboss.identity.federation.core.saml.v2.util.DocumentUtil;
import org.jboss.identity.federation.core.util.JAXBUtil;
import org.jboss.identity.federation.saml.v2.profiles.xacml.assertion.ObjectFactory;
import org.jboss.identity.federation.saml.v2.profiles.xacml.assertion.XACMLAuthzDecisionStatementType;
import org.jboss.identity.federation.saml.v2.profiles.xacml.protocol.XACMLAuthzDecisionQueryType;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPSAMLXACMLUtil {
    private static String SOAP_PKG = "org.jboss.identity.federation.org.xmlsoap.schemas.soap.envelope";
    private static String SAML_PROTO_PKG = "org.jboss.identity.federation.saml.v2.protocol";
    private static String XACML_CTX_PKG = "org.jboss.security.xacml.core.model.context";
    private static String XACML_SAMLPROTO_PKG = "org.jboss.identity.federation.saml.v2.profiles.xacml.protocol";
    private static String XACML_SAMLASSERT_PKG = "org.jboss.identity.federation.saml.v2.profiles.xacml.assertion";
    private static String COLON = ":";
    private static String collectivePackage = SOAPSAMLXACMLUtil.getPackage();
    private static org.jboss.identity.federation.saml.v2.profiles.xacml.protocol.ObjectFactory queryTypeObjectFactory = new org.jboss.identity.federation.saml.v2.profiles.xacml.protocol.ObjectFactory();
    private static ObjectFactory statementObjectFactory = new ObjectFactory();

    public static XACMLAuthzDecisionQueryType getXACMLQueryType(Element samlRequest) throws ConfigurationException, ProcessingException, JAXBException {
        String elementString = DocumentUtil.getDOMElementAsString(samlRequest);
        Unmarshaller um = JAXBUtil.getUnmarshaller(collectivePackage);
        um.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
        JAXBElement obj = (JAXBElement)um.unmarshal((Reader)new StringReader(elementString));
        Object xacmlObject = obj.getValue();
        if (!(xacmlObject instanceof XACMLAuthzDecisionQueryType)) {
            throw new RuntimeException("Unsupported type:" + xacmlObject);
        }
        return (XACMLAuthzDecisionQueryType)xacmlObject;
    }

    public static XACMLAuthzDecisionQueryType createXACMLAuthzDecisionQueryType() {
        return queryTypeObjectFactory.createXACMLAuthzDecisionQueryType();
    }

    public static XACMLAuthzDecisionStatementType createXACMLAuthzDecisionStatementType() {
        return statementObjectFactory.createXACMLAuthzDecisionStatementType();
    }

    public static JAXBElement<XACMLAuthzDecisionQueryType> getJAXB(XACMLAuthzDecisionQueryType queryType) {
        return queryTypeObjectFactory.createXACMLAuthzDecisionQuery(queryType);
    }

    public static JAXBElement<XACMLAuthzDecisionStatementType> getJAXB(XACMLAuthzDecisionStatementType stmtType) {
        return statementObjectFactory.createXACMLAuthzDecisionStatement(stmtType);
    }

    public static Marshaller getMarshaller() throws JAXBException {
        return JAXBUtil.getMarshaller(SOAPSAMLXACMLUtil.getPackage());
    }

    public static Unmarshaller getUnmarshaller() throws JAXBException {
        return JAXBUtil.getUnmarshaller(SOAPSAMLXACMLUtil.getPackage());
    }

    public static String getPackage() {
        StringBuffer buf = new StringBuffer();
        buf.append(SOAP_PKG).append(COLON).append(SAML_PROTO_PKG).append(COLON);
        buf.append(XACML_CTX_PKG).append(COLON).append(XACML_SAMLPROTO_PKG).append(COLON).append(XACML_SAMLASSERT_PKG);
        return buf.toString();
    }
}

