/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.core.wstrust;

import java.io.InputStream;
import java.net.URL;
import javax.annotation.Resource;
import javax.xml.bind.JAXBElement;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceProvider;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.core.config.STSType;
import org.jboss.identity.federation.core.exceptions.ConfigurationException;
import org.jboss.identity.federation.core.exceptions.ParsingException;
import org.jboss.identity.federation.core.saml.v2.common.SAMLDocumentHolder;
import org.jboss.identity.federation.core.util.JAXBUtil;
import org.jboss.identity.federation.core.wstrust.JBossSTSConfiguration;
import org.jboss.identity.federation.core.wstrust.STSConfiguration;
import org.jboss.identity.federation.core.wstrust.SecurityActions;
import org.jboss.identity.federation.core.wstrust.SecurityTokenService;
import org.jboss.identity.federation.core.wstrust.WSTrustException;
import org.jboss.identity.federation.core.wstrust.WSTrustJAXBFactory;
import org.jboss.identity.federation.core.wstrust.WSTrustRequestHandler;
import org.jboss.identity.federation.core.wstrust.wrappers.BaseRequestSecurityToken;
import org.jboss.identity.federation.core.wstrust.wrappers.RequestSecurityToken;
import org.jboss.identity.federation.core.wstrust.wrappers.RequestSecurityTokenCollection;
import org.jboss.identity.federation.core.wstrust.wrappers.RequestSecurityTokenResponse;
import org.jboss.identity.federation.core.wstrust.wrappers.RequestSecurityTokenResponseCollection;
import org.w3c.dom.Document;

@WebServiceProvider(serviceName="JBossSTS", portName="JBossSTSPort", targetNamespace="http://org.jboss.identity.trust/sts", wsdlLocation="WEB-INF/wsdl/JBossSTS.wsdl")
@ServiceMode(value=Service.Mode.PAYLOAD)
public class JBossSTS
implements SecurityTokenService {
    private static Logger logger = Logger.getLogger(JBossSTS.class);
    @Resource
    protected WebServiceContext context;
    protected STSConfiguration config;

    public Source invoke(Source request) {
        BaseRequestSecurityToken baseRequest;
        try {
            baseRequest = WSTrustJAXBFactory.getInstance().parseRequestSecurityToken(request);
        }
        catch (ParsingException e) {
            throw new RuntimeException(e);
        }
        if (baseRequest instanceof RequestSecurityToken) {
            return this.handleTokenRequest((RequestSecurityToken)baseRequest);
        }
        if (baseRequest instanceof RequestSecurityTokenCollection) {
            return this.handleTokenRequestCollection((RequestSecurityTokenCollection)baseRequest);
        }
        throw new WebServiceException("Invalid security token request");
    }

    protected Source handleTokenRequest(RequestSecurityToken request) {
        SAMLDocumentHolder holder = WSTrustJAXBFactory.getInstance().getSAMLDocumentHolderOnThread();
        request.setRSTDocument(holder.getSamlDocument());
        if (this.config == null) {
            try {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"Loading STS configuration");
                }
                this.config = this.getConfiguration();
            }
            catch (ConfigurationException e) {
                throw new WebServiceException("Encountered configuration exception:", (Throwable)e);
            }
        }
        WSTrustRequestHandler handler = this.config.getRequestHandler();
        String requestType = request.getRequestType().toString();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("STS received request of type " + requestType));
        }
        try {
            if (requestType.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Issue")) {
                Source source = this.marshallResponse(handler.issue(request, this.context.getUserPrincipal()));
                Document doc = handler.postProcess((Document)((DOMSource)source).getNode(), request);
                return new DOMSource(doc);
            }
            if (requestType.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Renew")) {
                return this.marshallResponse(handler.renew(request, this.context.getUserPrincipal()));
            }
            if (requestType.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Cancel")) {
                return this.marshallResponse(handler.cancel(request, this.context.getUserPrincipal()));
            }
            if (requestType.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Validate")) {
                return this.marshallResponse(handler.validate(request, this.context.getUserPrincipal()));
            }
            throw new WSTrustException("Invalid request type: " + requestType);
        }
        catch (WSTrustException we) {
            throw new WebServiceException("Exception in handling token request:", (Throwable)we);
        }
    }

    protected Source handleTokenRequestCollection(RequestSecurityTokenCollection requestCollection) {
        throw new UnsupportedOperationException();
    }

    protected Source marshallResponse(RequestSecurityTokenResponse response) {
        RequestSecurityTokenResponseCollection responseCollection = new RequestSecurityTokenResponseCollection();
        responseCollection.addRequestSecurityTokenResponse(response);
        return WSTrustJAXBFactory.getInstance().marshallRequestSecurityTokenResponse(responseCollection);
    }

    protected STSConfiguration getConfiguration() throws ConfigurationException {
        URL configurationFile = SecurityActions.getContextClassLoader().getResource("jboss-sts.xml");
        if (configurationFile == null) {
            logger.warn((Object)"jboss-sts.xml configuration file not found. Using default configuration values");
            return new JBossSTSConfiguration();
        }
        try {
            String pkgName = "org.jboss.identity.federation.core.config";
            InputStream stream = configurationFile.openStream();
            JAXBElement element = (JAXBElement)JAXBUtil.getUnmarshaller(pkgName).unmarshal(stream);
            STSType stsConfig = (STSType)element.getValue();
            JBossSTSConfiguration configuration = new JBossSTSConfiguration(stsConfig);
            if (logger.isInfoEnabled()) {
                logger.info((Object)"jboss-sts.xml configuration file loaded");
            }
            return configuration;
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing the configuration file:", e);
        }
    }
}

