/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.core.wstrust;

import java.security.KeyPair;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;
import org.jboss.identity.federation.core.config.ClaimsProcessorType;
import org.jboss.identity.federation.core.config.ClaimsProcessorsType;
import org.jboss.identity.federation.core.config.KeyProviderType;
import org.jboss.identity.federation.core.config.KeyValueType;
import org.jboss.identity.federation.core.config.STSType;
import org.jboss.identity.federation.core.config.ServiceProviderType;
import org.jboss.identity.federation.core.config.ServiceProvidersType;
import org.jboss.identity.federation.core.config.TokenProviderType;
import org.jboss.identity.federation.core.config.TokenProvidersType;
import org.jboss.identity.federation.core.interfaces.TrustKeyManager;
import org.jboss.identity.federation.core.wstrust.ClaimsProcessor;
import org.jboss.identity.federation.core.wstrust.STSConfiguration;
import org.jboss.identity.federation.core.wstrust.SecurityActions;
import org.jboss.identity.federation.core.wstrust.SecurityTokenProvider;
import org.jboss.identity.federation.core.wstrust.WSTrustRequestHandler;
import org.jboss.identity.federation.core.wstrust.WSTrustServiceFactory;

public class JBossSTSConfiguration
implements STSConfiguration {
    private final STSType delegate;
    private final Map<String, SecurityTokenProvider> tokenProviders = new HashMap<String, SecurityTokenProvider>();
    private final Map<String, ServiceProviderType> spMetadata = new HashMap<String, ServiceProviderType>();
    private final Map<String, ClaimsProcessor> claimsProcessors = new HashMap<String, ClaimsProcessor>();
    private TrustKeyManager trustManager;
    private WSTrustRequestHandler handler;

    public JBossSTSConfiguration() {
        this.delegate = new STSType();
        this.delegate.setRequestHandler("org.jboss.identity.federation.core.wstrust.StandardRequestHandler");
    }

    public JBossSTSConfiguration(STSType config) {
        KeyProviderType keyProviderType;
        ServiceProvidersType serviceProviders;
        ClaimsProcessorsType processors;
        TokenProvidersType providers;
        this.delegate = config;
        if (this.delegate.getRequestHandler() == null) {
            this.delegate.setRequestHandler("org.jboss.identity.federation.core.wstrust.StandardRequestHandler");
        }
        if ((providers = this.delegate.getTokenProviders()) != null) {
            for (TokenProviderType provider : providers.getTokenProvider()) {
                HashMap<String, String> properties = new HashMap<String, String>();
                for (KeyValueType propertyType : provider.getProperty()) {
                    properties.put(propertyType.getKey(), propertyType.getValue());
                }
                SecurityTokenProvider tokenProvider = WSTrustServiceFactory.getInstance().createTokenProvider(provider.getProviderClass(), properties);
                this.tokenProviders.put(provider.getTokenType(), tokenProvider);
                String tokenElementAndNS = provider.getTokenElement() + "$" + provider.getTokenElementNS();
                this.tokenProviders.put(tokenElementAndNS, tokenProvider);
            }
        }
        if ((processors = this.delegate.getClaimsProcessors()) != null) {
            for (ClaimsProcessorType processor : processors.getClaimsProcessor()) {
                HashMap<String, String> properties = new HashMap<String, String>();
                for (KeyValueType propertyType : processor.getProperty()) {
                    properties.put(propertyType.getKey(), propertyType.getValue());
                }
                ClaimsProcessor claimsProcessor = WSTrustServiceFactory.getInstance().createClaimsProcessor(processor.getProcessorClass(), properties);
                this.claimsProcessors.put(processor.getDialect(), claimsProcessor);
            }
        }
        if ((serviceProviders = this.delegate.getServiceProviders()) != null) {
            for (ServiceProviderType provider : serviceProviders.getServiceProvider()) {
                this.spMetadata.put(provider.getEndpoint(), provider);
            }
        }
        if ((keyProviderType = config.getKeyProvider()) != null) {
            String keyManagerClassName = keyProviderType.getClassName();
            try {
                this.trustManager = (TrustKeyManager)SecurityActions.instantiateClass(keyManagerClassName);
                this.trustManager.setAuthProperties(keyProviderType.getAuth());
                this.trustManager.setValidatingAlias(keyProviderType.getValidatingAlias());
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to construct the key manager:", e);
            }
        }
    }

    public String getSTSName() {
        return this.delegate.getSTSName();
    }

    public boolean encryptIssuedToken() {
        return this.delegate.isEncryptToken();
    }

    public boolean signIssuedToken() {
        return this.delegate.isSignToken();
    }

    public long getIssuedTokenTimeout() {
        return this.delegate.getTokenTimeout() * 1000;
    }

    public WSTrustRequestHandler getRequestHandler() {
        if (this.handler == null) {
            this.handler = WSTrustServiceFactory.getInstance().createRequestHandler(this.delegate.getRequestHandler(), this);
        }
        return this.handler;
    }

    public SecurityTokenProvider getProviderForService(String serviceName) {
        ServiceProviderType provider = this.spMetadata.get(serviceName);
        if (provider != null) {
            return this.tokenProviders.get(provider.getTokenType());
        }
        return null;
    }

    public SecurityTokenProvider getProviderForTokenType(String tokenType) {
        return this.tokenProviders.get(tokenType);
    }

    public SecurityTokenProvider getProviderForTokenElementNS(String tokenLocalName, String tokenNamespace) {
        return this.tokenProviders.get(tokenLocalName + "$" + tokenNamespace);
    }

    public ClaimsProcessor getClaimsProcessor(String claimsDialect) {
        return this.claimsProcessors.get(claimsDialect);
    }

    public String getTokenTypeForService(String serviceName) {
        ServiceProviderType provider = this.spMetadata.get(serviceName);
        if (provider != null) {
            return provider.getTokenType();
        }
        return null;
    }

    public PublicKey getServiceProviderPublicKey(String serviceName) {
        PublicKey key = null;
        if (this.trustManager != null) {
            try {
                ServiceProviderType provider = this.spMetadata.get(serviceName);
                if (provider != null && provider.getTruststoreAlias() != null) {
                    key = this.trustManager.getPublicKey(provider.getTruststoreAlias());
                }
                if (key == null) {
                    key = this.trustManager.getValidatingKey(serviceName);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error obtaining public key for service " + serviceName, e);
            }
        }
        return key;
    }

    public KeyPair getSTSKeyPair() {
        KeyPair keyPair = null;
        if (this.trustManager != null) {
            try {
                keyPair = this.trustManager.getSigningKeyPair();
            }
            catch (Exception e) {
                throw new RuntimeException("Error obtaining signing key pair:", e);
            }
        }
        return keyPair;
    }

    public Certificate getCertificate(String alias) {
        Certificate certificate = null;
        if (this.trustManager != null) {
            try {
                certificate = this.trustManager.getCertificate(alias);
            }
            catch (Exception e) {
                throw new RuntimeException("Error obtaining public key certificate", e);
            }
        }
        return certificate;
    }
}

