/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.core.wstrust;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jboss.identity.federation.core.exceptions.ConfigurationException;
import org.jboss.identity.federation.core.exceptions.ParsingException;
import org.jboss.identity.federation.core.exceptions.ProcessingException;
import org.jboss.identity.federation.core.saml.v2.util.DocumentUtil;
import org.jboss.identity.federation.core.util.StringUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class SamlCredential
implements Serializable {
    private static final long serialVersionUID = -8496414959425288835L;
    private static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();
    private String assertion;

    public SamlCredential(Element assertion) {
        if (assertion == null) {
            throw new IllegalArgumentException("assertion Element must not be null");
        }
        this.assertion = SamlCredential.assertionToString(assertion);
    }

    public SamlCredential(String assertion) {
        if (StringUtil.isNullOrEmpty(assertion)) {
            throw new IllegalArgumentException("assertion String must not be null or empty");
        }
        this.assertion = assertion;
    }

    public String getAssertionAsString() {
        return this.assertion;
    }

    public Element getAssertionAsElement() throws ProcessingException {
        try {
            return SamlCredential.assertionToElement(this.assertion);
        }
        catch (ConfigurationException e) {
            throw new ProcessingException(e.getMessage(), e);
        }
        catch (ParsingException e) {
            throw new ProcessingException(e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new ProcessingException(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new ProcessingException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ProcessingException(e.getMessage(), e);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SamlCredential)) {
            return false;
        }
        SamlCredential that = (SamlCredential)obj;
        return this.assertion.equals(that.assertion);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.assertion.hashCode();
        return result;
    }

    public String toString() {
        return "SamlCredential[" + this.assertion + "]";
    }

    public static Element assertionToElement(String assertion) throws ParserConfigurationException, SAXException, IOException, ConfigurationException, ParsingException, ProcessingException {
        Document document = DocumentUtil.getDocument(assertion);
        return (Element)document.getFirstChild();
    }

    public static String assertionToString(Element assertion) {
        if (assertion == null) {
            throw new IllegalArgumentException("assertion Element must not be null");
        }
        try {
            Transformer transformer = TRANSFORMER_FACTORY.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            DOMSource source = new DOMSource(assertion);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            transformer.transform(source, result);
            return writer.toString();
        }
        catch (TransformerConfigurationException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        catch (TransformerException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

