/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.core.wstrust;

import java.security.PrivilegedActionException;
import java.util.Map;
import org.jboss.identity.federation.core.wstrust.ClaimsProcessor;
import org.jboss.identity.federation.core.wstrust.STSConfiguration;
import org.jboss.identity.federation.core.wstrust.SecurityActions;
import org.jboss.identity.federation.core.wstrust.SecurityTokenProvider;
import org.jboss.identity.federation.core.wstrust.WSTrustRequestHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSTrustServiceFactory {
    private static final WSTrustServiceFactory factory = new WSTrustServiceFactory();

    private WSTrustServiceFactory() {
    }

    public static WSTrustServiceFactory getInstance() {
        return factory;
    }

    public WSTrustRequestHandler createRequestHandler(String handlerClassName, STSConfiguration configuration) {
        try {
            WSTrustRequestHandler handler = (WSTrustRequestHandler)SecurityActions.instantiateClass(handlerClassName);
            handler.initialize(configuration);
            return handler;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public SecurityTokenProvider createTokenProvider(String providerClass, Map<String, String> properties) {
        try {
            SecurityTokenProvider tokenProvider = (SecurityTokenProvider)SecurityActions.instantiateClass(providerClass);
            tokenProvider.initialize(properties);
            return tokenProvider;
        }
        catch (PrivilegedActionException pae) {
            throw new RuntimeException("Unable to instantiate token provider " + providerClass, pae);
        }
    }

    public ClaimsProcessor createClaimsProcessor(String processorClass, Map<String, String> properties) {
        try {
            ClaimsProcessor claimsProcessor = (ClaimsProcessor)SecurityActions.instantiateClass(processorClass);
            claimsProcessor.initialize(properties);
            return claimsProcessor;
        }
        catch (PrivilegedActionException pae) {
            throw new RuntimeException("Unable to instantiate claims processor " + processorClass, pae);
        }
    }
}

