/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.core.wstrust.auth;

import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.core.exceptions.ParsingException;
import org.jboss.identity.federation.core.wstrust.STSClient;
import org.jboss.identity.federation.core.wstrust.STSClientConfig;
import org.jboss.identity.federation.core.wstrust.STSClientFactory;
import org.jboss.identity.federation.core.wstrust.SamlCredential;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSTSLoginModule
implements LoginModule {
    private Logger log = Logger.getLogger(AbstractSTSLoginModule.class);
    public static final String SHARED_TOKEN = "org.jboss.identity.federation.core.wstrust.lm.stsToken";
    public static final String STS_CONFIG_FILE = "configFile";
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Element samlToken;
    private boolean success;
    private Map<String, ?> options;
    private Map<String, ?> sharedState;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.options = options;
        this.sharedState = sharedState;
    }

    @Override
    public abstract boolean login() throws LoginException;

    @Override
    public boolean commit() throws LoginException {
        if (this.success) {
            SamlCredential samlCredential = new SamlCredential(this.samlToken);
            boolean added = this.subject.getPublicCredentials().add(samlCredential);
            if (added && this.log.isDebugEnabled()) {
                this.log.debug((Object)("Added Credential :" + samlCredential));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean abort() throws LoginException {
        this.success = false;
        this.clearState();
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.clearState();
        return true;
    }

    protected STSClientConfig getConfiguration(Map<String, ?> options) {
        String configFile = this.getRequiredOption(options, STS_CONFIG_FILE);
        return new STSClientConfig.Builder(configFile).build();
    }

    protected STSClient createWSTrustClient(STSClientConfig config) {
        try {
            return STSClientFactory.getInstance().create(config);
        }
        catch (ParsingException e) {
            throw new IllegalStateException("Could not create WSTrustClient:", e);
        }
    }

    protected String getRequiredOption(Map<String, ?> options, String optionName) {
        String option = (String)options.get(optionName);
        if (option == null) {
            throw new IllegalArgumentException("Required option '" + optionName + "' was missing from the login modules configuration");
        }
        return option;
    }

    protected boolean isSuccess() {
        return this.success;
    }

    protected void setSuccess(boolean success) {
        this.success = success;
    }

    protected Subject getSubject() {
        return this.subject;
    }

    protected CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    protected void setSamlToken(Element samlToken) {
        this.samlToken = samlToken;
    }

    protected void setSharedToken(Object token) {
        if (this.sharedState == null) {
            return;
        }
        Map<String, ?> state = this.sharedState;
        state.put(SHARED_TOKEN, token);
    }

    protected Object getSharedToken() {
        if (this.sharedState == null) {
            return null;
        }
        return this.sharedState.get(SHARED_TOKEN);
    }

    protected Map<String, ?> getOptions() {
        return this.options;
    }

    protected String getSharedUsername() {
        if (this.sharedState == null) {
            return null;
        }
        return (String)this.sharedState.get("javax.security.auth.login.name");
    }

    protected char[] getSharedPassword() {
        if (this.sharedState == null) {
            return null;
        }
        return (char[])this.sharedState.get("javax.security.auth.login.password");
    }

    protected boolean isUseFirstPass() {
        if (this.options == null) {
            return false;
        }
        String passwordStacking = (String)this.options.get("password-stacking");
        return "useFirstPass".equals(passwordStacking);
    }

    private void clearState() {
        this.removeAllSamlCredentials(this.subject);
        this.samlToken = null;
    }

    private void removeAllSamlCredentials(Subject subject) {
        Set<SamlCredential> samlCredentials = subject.getPublicCredentials(SamlCredential.class);
        if (!samlCredentials.isEmpty()) {
            subject.getPublicCredentials().removeAll(samlCredentials);
        }
    }
}

