/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.core.wstrust.auth;

import java.io.IOException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.jboss.identity.federation.core.wstrust.STSClient;
import org.jboss.identity.federation.core.wstrust.STSClientConfig;
import org.jboss.identity.federation.core.wstrust.WSTrustException;
import org.jboss.identity.federation.core.wstrust.auth.AbstractSTSLoginModule;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STSIssuingLoginModule
extends AbstractSTSLoginModule {
    public static final String ENDPOINT_OPTION = "endpointURI";
    public static final String TOKEN_TYPE_OPTION = "tokenType";
    private String endpointURI;
    private String tokenType;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        if (callbackHandler == null && !this.isUseFirstPass()) {
            throw new IllegalArgumentException("CallbackHandler must not be null");
        }
        this.endpointURI = (String)options.get(ENDPOINT_OPTION);
        this.tokenType = (String)options.get(TOKEN_TYPE_OPTION);
    }

    @Override
    public boolean login() throws LoginException {
        try {
            STSClientConfig.Builder builder = new STSClientConfig.Builder(this.getRequiredOption(this.getOptions(), "configFile"));
            if (this.isUseFirstPass()) {
                builder.username(this.getSharedUsername()).password(new String(this.getSharedPassword()));
            } else {
                NameCallback nameCallback = new NameCallback("user:");
                PasswordCallback passwordCallback = new PasswordCallback("password:", true);
                try {
                    this.getCallbackHandler().handle(new Callback[]{nameCallback, passwordCallback});
                    builder.username(nameCallback.getName()).password(new String(passwordCallback.getPassword()));
                }
                catch (IOException e) {
                    throw new LoginException(e.getMessage());
                }
                catch (UnsupportedCallbackException e) {
                    throw new LoginException(e.getMessage());
                }
            }
            STSClient stsClient = this.createWSTrustClient(builder.build());
            Element token = stsClient.issueToken(this.endpointURI, this.tokenType);
            if (token == null) {
                throw new LoginException("Could not issue a SAML Security Token");
            }
            this.setSuccess(true);
            this.setSamlToken(token);
            this.setSharedToken(token);
            return true;
        }
        catch (WSTrustException e) {
            throw new LoginException("WSTrustException : " + e.getMessage());
        }
    }
}

