/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.core.wstrust.auth;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.core.wstrust.STSClient;
import org.jboss.identity.federation.core.wstrust.WSTrustException;
import org.jboss.identity.federation.core.wstrust.auth.AbstractSTSLoginModule;
import org.jboss.identity.federation.core.wstrust.auth.TokenCallback;
import org.w3c.dom.Element;

public class STSValidatingLoginModule
extends AbstractSTSLoginModule {
    private Logger log = Logger.getLogger(STSValidatingLoginModule.class);

    public boolean login() throws LoginException {
        STSClient stsClient = this.createWSTrustClient(this.getConfiguration(this.getOptions()));
        try {
            Element token = (Element)this.getSharedToken();
            if (token == null) {
                token = this.getSamlTokenFromCaller();
            }
            boolean success = stsClient.validateToken(token);
            this.log.debug((Object)("Validation result: " + success));
            this.setSuccess(success);
            if (!this.isSuccess()) {
                throw new LoginException("Could not validate the SAML Security Token :" + token);
            }
            this.setSamlToken(token);
            return success;
        }
        catch (WSTrustException e) {
            throw new LoginException("WSTrustException : " + e.getMessage());
        }
        catch (IOException e) {
            throw new LoginException("IOException : " + e.getMessage());
        }
        catch (UnsupportedCallbackException e) {
            throw new LoginException("UnsupportedCallbackException : " + e.getMessage());
        }
    }

    private Element getSamlTokenFromCaller() throws UnsupportedCallbackException, LoginException, IOException {
        TokenCallback callback = new TokenCallback();
        this.getCallbackHandler().handle(new Callback[]{callback});
        Element token = (Element)callback.getToken();
        if (token == null) {
            throw new LoginException("Could not locate a Security Token from the callback.");
        }
        return token;
    }
}

