/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.core.wstrust.plugins.saml;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.core.saml.v2.common.IDGenerator;
import org.jboss.identity.federation.core.saml.v2.factories.SAMLAssertionFactory;
import org.jboss.identity.federation.core.saml.v2.util.AssertionUtil;
import org.jboss.identity.federation.core.saml.v2.util.StatementUtil;
import org.jboss.identity.federation.core.wstrust.SecurityTokenProvider;
import org.jboss.identity.federation.core.wstrust.StandardSecurityToken;
import org.jboss.identity.federation.core.wstrust.WSTrustException;
import org.jboss.identity.federation.core.wstrust.WSTrustRequestContext;
import org.jboss.identity.federation.core.wstrust.WSTrustUtil;
import org.jboss.identity.federation.core.wstrust.plugins.saml.SAMLUtil;
import org.jboss.identity.federation.core.wstrust.wrappers.Lifetime;
import org.jboss.identity.federation.saml.v2.assertion.AssertionType;
import org.jboss.identity.federation.saml.v2.assertion.AudienceRestrictionType;
import org.jboss.identity.federation.saml.v2.assertion.ConditionsType;
import org.jboss.identity.federation.saml.v2.assertion.KeyInfoConfirmationDataType;
import org.jboss.identity.federation.saml.v2.assertion.NameIDType;
import org.jboss.identity.federation.saml.v2.assertion.StatementAbstractType;
import org.jboss.identity.federation.saml.v2.assertion.SubjectConfirmationType;
import org.jboss.identity.federation.saml.v2.assertion.SubjectType;
import org.jboss.identity.federation.ws.policy.AppliesTo;
import org.jboss.identity.federation.ws.trust.RequestedReferenceType;
import org.jboss.identity.federation.ws.trust.StatusType;
import org.jboss.identity.federation.ws.trust.ValidateTargetType;
import org.jboss.identity.federation.ws.wss.secext.KeyIdentifierType;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAML20TokenProvider
implements SecurityTokenProvider {
    private static Logger logger = Logger.getLogger(SAML20TokenProvider.class);
    private Map<String, String> properties;

    @Override
    public void initialize(Map<String, String> properties) {
        this.properties = properties;
    }

    @Override
    public void cancelToken(WSTrustRequestContext context) throws WSTrustException {
    }

    @Override
    public void issueToken(WSTrustRequestContext context) throws WSTrustException {
        String assertionID = IDGenerator.create("ID_");
        this.issueToken(context, assertionID);
    }

    @Override
    public void renewToken(WSTrustRequestContext context) throws WSTrustException {
        Element assertion = (Element)context.getRequestSecurityToken().getRenewTarget().getAny();
        String id = assertion.getAttribute("ID");
        this.issueToken(context, id);
    }

    @Override
    public void validateToken(WSTrustRequestContext context) throws WSTrustException {
        ValidateTargetType validateTarget;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"SAML V2.0 token validation started");
        }
        if ((validateTarget = context.getRequestSecurityToken().getValidateTarget()) == null) {
            throw new WSTrustException("Invalid validate message: missing required ValidateTarget");
        }
        String code = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/valid";
        String reason = "SAMLV2.0 Assertion successfuly validated";
        AssertionType assertion = null;
        Object assertionObj = validateTarget.getAny();
        if (assertionObj instanceof JAXBElement) {
            JAXBElement assertionType = (JAXBElement)validateTarget.getAny();
            assertion = (AssertionType)assertionType.getValue();
        } else if (assertionObj instanceof Element) {
            Element assertionElement = (Element)assertionObj;
            if (!this.isAssertion(assertionElement)) {
                code = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/invalid";
                reason = "Validation failure: supplied token is not a SAMLV2.0 Assertion";
            } else {
                try {
                    assertion = SAMLUtil.fromElement((Element)assertionObj);
                }
                catch (JAXBException e) {
                    throw new WSTrustException("Unmarshalling error:", e);
                }
            }
        }
        try {
            if (AssertionUtil.hasExpired(assertion)) {
                code = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/invalid";
                reason = "Validation failure: assertion expired or used before its lifetime period";
            }
        }
        catch (Exception ce) {
            code = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/invalid";
            reason = "Validation failure: unable to verify assertion lifetime: " + ce.getMessage();
        }
        StatusType status = new StatusType();
        status.setCode(code);
        status.setReason(reason);
        context.setStatus(status);
    }

    private boolean isAssertion(Element element) {
        return element == null ? false : "Assertion".equals(element.getLocalName()) && "urn:oasis:names:tc:SAML:2.0:assertion".equals(element.getNamespaceURI());
    }

    private void issueToken(WSTrustRequestContext context, String assertionID) throws WSTrustException {
        Lifetime lifetime = context.getRequestSecurityToken().getLifetime();
        AudienceRestrictionType restriction = null;
        AppliesTo appliesTo = context.getRequestSecurityToken().getAppliesTo();
        if (appliesTo != null) {
            restriction = SAMLAssertionFactory.createAudienceRestriction(WSTrustUtil.parseAppliesTo(appliesTo));
        }
        ConditionsType conditions = SAMLAssertionFactory.createConditions(lifetime.getCreated(), lifetime.getExpires(), restriction);
        String confirmationMethod = null;
        KeyInfoConfirmationDataType keyInfoDataType = null;
        if (context.getProofTokenInfo() != null) {
            confirmationMethod = "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key";
            keyInfoDataType = SAMLAssertionFactory.createKeyInfoConfirmation(context.getProofTokenInfo());
        } else {
            confirmationMethod = "urn:oasis:names:tc:SAML:2.0:cm:bearer";
        }
        SubjectConfirmationType subjectConfirmation = SAMLAssertionFactory.createSubjectConfirmation(null, confirmationMethod, keyInfoDataType);
        Principal principal = context.getCallerPrincipal();
        String subjectName = principal == null ? "ANONYMOUS" : principal.getName();
        NameIDType nameID = SAMLAssertionFactory.createNameID(null, "urn:jboss:identity-federation", subjectName);
        SubjectType subject = SAMLAssertionFactory.createSubject(nameID, subjectConfirmation);
        ArrayList<StatementAbstractType> statements = null;
        Map<String, Object> claimedAttributes = context.getClaimedAttributes();
        if (claimedAttributes != null) {
            statements = new ArrayList<StatementAbstractType>();
            statements.add(StatementUtil.createAttributeStatement(claimedAttributes));
        }
        NameIDType issuerID = SAMLAssertionFactory.createNameID(null, null, context.getTokenIssuer());
        AssertionType assertion = SAMLAssertionFactory.createAssertion(assertionID, issuerID, lifetime.getCreated(), conditions, subject, statements);
        Element assertionElement = null;
        try {
            assertionElement = SAMLUtil.toElement(assertion);
        }
        catch (Exception e) {
            throw new WSTrustException("Failed to marshall SAMLV2 assertion", e);
        }
        StandardSecurityToken token = new StandardSecurityToken(context.getRequestSecurityToken().getTokenType().toString(), assertionElement, assertionID);
        context.setSecurityToken(token);
        KeyIdentifierType keyIdentifier = WSTrustUtil.createKeyIdentifier("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID", "#" + assertionID);
        HashMap<QName, String> attributes = new HashMap<QName, String>();
        attributes.put(new QName("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "TokenType"), "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
        RequestedReferenceType attachedReference = WSTrustUtil.createRequestedReference(keyIdentifier, attributes);
        context.setAttachedReference(attachedReference);
    }
}

