/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.core.wstrust.plugins.saml;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.jboss.identity.federation.core.saml.v2.util.DocumentUtil;
import org.jboss.identity.federation.core.util.JAXBUtil;
import org.jboss.identity.federation.saml.v2.assertion.AssertionType;
import org.jboss.identity.federation.saml.v2.assertion.ObjectFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLUtil {
    public static final String SAML2_BEARER_URI = "urn:oasis:names:tc:SAML:2.0:cm:bearer";
    public static final String SAML2_HOLDER_OF_KEY_URI = "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key";
    public static final String SAML2_SENDER_VOUCHES_URI = "urn:oasis:names:tc:SAML:2.0:cm:sender-vouches";
    public static final String SAML2_TOKEN_TYPE = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0";
    public static final String SAML2_VALUE_TYPE = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID";

    public static Element toElement(AssertionType assertion) throws Exception {
        Document document = DocumentUtil.createDocument();
        DOMResult result = new DOMResult(document);
        Marshaller marshaller = JAXBUtil.getMarshaller("org.jboss.identity.federation.saml.v2.assertion");
        marshaller.marshal(new ObjectFactory().createAssertion(assertion), (Result)result);
        return document.getDocumentElement();
    }

    public static AssertionType fromElement(Element assertionElement) throws JAXBException {
        JAXBElement element;
        Unmarshaller unmarshaller = JAXBUtil.getUnmarshaller("org.jboss.identity.federation.saml.v2.assertion");
        Object object = unmarshaller.unmarshal((Node)assertionElement);
        if (object instanceof AssertionType) {
            return (AssertionType)object;
        }
        if (object instanceof JAXBElement && (element = (JAXBElement)object).getDeclaredType().equals(AssertionType.class)) {
            return (AssertionType)element.getValue();
        }
        throw new IllegalArgumentException("Supplied document does not contain a SAMLV2.0 Assertion");
    }
}

