/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.web.process;

import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.jboss.identity.federation.api.saml.v2.request.SAML2Request;
import org.jboss.identity.federation.core.exceptions.ConfigurationException;
import org.jboss.identity.federation.core.exceptions.ParsingException;
import org.jboss.identity.federation.core.exceptions.ProcessingException;
import org.jboss.identity.federation.core.saml.v2.common.SAMLDocumentHolder;
import org.jboss.identity.federation.core.saml.v2.holders.DestinationInfoHolder;
import org.jboss.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerResponse;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.jboss.identity.federation.core.saml.v2.util.DocumentUtil;
import org.jboss.identity.federation.core.util.StringUtil;
import org.jboss.identity.federation.saml.v2.SAML2Object;
import org.jboss.identity.federation.web.core.HTTPContext;
import org.jboss.identity.federation.web.process.SAMLHandlerChainProcessor;
import org.jboss.identity.federation.web.process.ServiceProviderBaseProcessor;
import org.jboss.identity.federation.web.util.HTTPRedirectUtil;
import org.jboss.identity.federation.web.util.PostBindingUtil;
import org.jboss.identity.federation.web.util.RedirectBindingUtil;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceProviderSAMLRequestProcessor
extends ServiceProviderBaseProcessor {
    public ServiceProviderSAMLRequestProcessor(boolean postBinding, String serviceURL) {
        super(postBinding, serviceURL);
    }

    public boolean process(String samlRequest, HTTPContext httpContext, Set<SAML2Handler> handlers) throws ProcessingException, IOException, ParsingException, ConfigurationException {
        InputStream is;
        SAML2Request saml2Request = new SAML2Request();
        DefaultSAML2HandlerResponse saml2HandlerResponse = null;
        SAML2Object samlObject = null;
        SAMLDocumentHolder documentHolder = null;
        if (this.postBinding) {
            is = PostBindingUtil.base64DecodeAsStream(samlRequest);
            samlObject = saml2Request.getSAML2ObjectFromStream(is);
        } else {
            is = RedirectBindingUtil.base64DeflateDecode(samlRequest);
            samlObject = saml2Request.getSAML2ObjectFromStream(is);
        }
        documentHolder = saml2Request.getSamlDocumentHolder();
        SAML2HandlerRequest saml2HandlerRequest = this.getSAML2HandlerRequest(documentHolder, httpContext);
        saml2HandlerResponse = new DefaultSAML2HandlerResponse();
        SAMLHandlerChainProcessor chainProcessor = new SAMLHandlerChainProcessor(handlers);
        chainProcessor.callHandlerChain(samlObject, saml2HandlerRequest, saml2HandlerResponse, httpContext);
        Document samlResponseDocument = saml2HandlerResponse.getResultingDocument();
        String relayState = saml2HandlerResponse.getRelayState();
        String destination = saml2HandlerResponse.getDestination();
        boolean willSendRequest = saml2HandlerResponse.getSendRequest();
        if (destination != null && samlResponseDocument != null) {
            if (this.postBinding) {
                this.sendRequestToIDP(destination, samlResponseDocument, relayState, httpContext.getResponse(), willSendRequest);
            } else {
                String samlMsg = DocumentUtil.getDocumentAsString(samlResponseDocument);
                String base64Request = RedirectBindingUtil.deflateBase64URLEncode(samlMsg.getBytes("UTF-8"));
                String destinationURL = destination + this.getDestination(base64Request, relayState, saml2HandlerResponse.getSendRequest());
                HTTPRedirectUtil.sendRedirectForRequestor(destinationURL, httpContext.getResponse());
            }
            return true;
        }
        return false;
    }

    protected void sendRequestToIDP(String destination, Document samlDocument, String relayState, HttpServletResponse response, boolean willSendRequest) throws ProcessingException, ConfigurationException, IOException {
        String samlMessage = DocumentUtil.getDocumentAsString(samlDocument);
        samlMessage = PostBindingUtil.base64Encode(samlMessage);
        PostBindingUtil.sendPost(new DestinationInfoHolder(destination, samlMessage, relayState), response, willSendRequest);
    }

    private String getDestination(String urlEncodedRequest, String urlEncodedRelayState, boolean sendRequest) {
        StringBuilder sb = new StringBuilder();
        if (sendRequest) {
            sb.append("?SAMLRequest=").append(urlEncodedRequest);
        } else {
            sb.append("?SAMLResponse=").append(urlEncodedRequest);
        }
        if (StringUtil.isNotNull(urlEncodedRelayState)) {
            sb.append("&RelayState=").append(urlEncodedRelayState);
        }
        return sb.toString();
    }
}

