/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.web.process;

import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.jboss.identity.federation.api.saml.v2.response.SAML2Response;
import org.jboss.identity.federation.core.exceptions.ConfigurationException;
import org.jboss.identity.federation.core.exceptions.ParsingException;
import org.jboss.identity.federation.core.exceptions.ProcessingException;
import org.jboss.identity.federation.core.saml.v2.common.SAMLDocumentHolder;
import org.jboss.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerResponse;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.jboss.identity.federation.saml.v2.SAML2Object;
import org.jboss.identity.federation.web.core.HTTPContext;
import org.jboss.identity.federation.web.process.SAMLHandlerChainProcessor;
import org.jboss.identity.federation.web.process.ServiceProviderBaseProcessor;
import org.jboss.identity.federation.web.util.PostBindingUtil;
import org.jboss.identity.federation.web.util.RedirectBindingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceProviderSAMLResponseProcessor
extends ServiceProviderBaseProcessor {
    public ServiceProviderSAMLResponseProcessor(boolean postBinding, String serviceURL) {
        super(postBinding, serviceURL);
    }

    public SAML2HandlerResponse process(String samlResponse, HTTPContext httpContext, Set<SAML2Handler> handlers) throws ProcessingException, IOException, ParsingException, ConfigurationException {
        SAML2Response saml2Response = new SAML2Response();
        SAMLDocumentHolder documentHolder = null;
        SAML2Object samlObject = null;
        if (this.postBinding) {
            InputStream is = PostBindingUtil.base64DecodeAsStream(samlResponse);
            samlObject = saml2Response.getSAML2ObjectFromStream(is);
            documentHolder = saml2Response.getSamlDocumentHolder();
        } else {
            InputStream base64DecodedResponse = RedirectBindingUtil.base64DeflateDecode(samlResponse);
            samlObject = saml2Response.getSAML2ObjectFromStream(base64DecodedResponse);
            documentHolder = saml2Response.getSamlDocumentHolder();
        }
        SAML2HandlerRequest saml2HandlerRequest = this.getSAML2HandlerRequest(documentHolder, httpContext);
        DefaultSAML2HandlerResponse saml2HandlerResponse = new DefaultSAML2HandlerResponse();
        SAMLHandlerChainProcessor chainProcessor = new SAMLHandlerChainProcessor(handlers);
        chainProcessor.callHandlerChain(samlObject, saml2HandlerRequest, saml2HandlerResponse, httpContext);
        return saml2HandlerResponse;
    }
}

