/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.web.roles;

import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jboss.identity.federation.core.interfaces.RoleGenerator;
import org.jboss.identity.federation.web.roles.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRoleGenerator
implements RoleGenerator {
    private static Properties props = new Properties();

    @Override
    public List<String> generateRoles(Principal principal) {
        ArrayList<String> roles = new ArrayList<String>();
        String csv = (String)props.get(principal.getName());
        StringTokenizer st = new StringTokenizer(csv, ",");
        while (st != null && st.hasMoreTokens()) {
            roles.add(st.nextToken());
        }
        return roles;
    }

    static {
        try {
            ClassLoader tcl = SecurityActions.getContextClassLoader();
            InputStream is = tcl.getResourceAsStream("roles.properties");
            if (is == null) {
                throw new RuntimeException("roles.properties not found");
            }
            props.load(is);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

