/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.web.servlets;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jboss.identity.federation.api.openid.provider.OpenIDParameterList;
import org.jboss.identity.federation.api.openid.provider.OpenIDProviderManager;

public class OpenIDProviderServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private transient ServletContext servletContext = null;
    private String securePageName = "securepage.jsp";
    private transient OpenIDProviderManager serverManager = new OpenIDProviderManager();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.servletContext = config.getServletContext();
        String secpageStr = this.servletContext.getInitParameter("securePage");
        if (secpageStr != null && secpageStr.length() > 0) {
            this.securePageName = secpageStr;
        }
        this.serverManager.initialize();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String responseText;
        OpenIDParameterList requestp;
        HttpSession session = request.getSession();
        if (this.serverManager.getEndPoint() == null) {
            this.serverManager.setEndPoint(request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath() + "/provider/");
        }
        if ("complete".equals(request.getParameter("_action"))) {
            requestp = (OpenIDParameterList)((Object)session.getAttribute("parameterlist"));
        } else {
            requestp = new OpenIDParameterList(request.getParameterMap());
            session.setAttribute("openid.identity", (Object)requestp.getParameter("openid.identity").getValue());
        }
        String mode = requestp.hasParameter("openid.mode") ? requestp.getParameterValue("openid.mode") : null;
        this.log("[OpenIDProviderServlet]:mode=" + mode + "::ParameterMap:" + (Object)((Object)requestp));
        if ("associate".equals(mode)) {
            OpenIDProviderManager.OpenIDMessage responsem = this.serverManager.processAssociationRequest(requestp);
            responseText = responsem.getResponseText();
        } else if ("checkid_setup".equals(mode) || "checkid_immediate".equals(mode)) {
            String userSelectedId = null;
            String userSelectedClaimedId = null;
            Boolean authenticatedAndApproved = Boolean.FALSE;
            if (session.getAttribute("authenticatedAndApproved") == null || (Boolean)session.getAttribute("authenticatedAndApproved") == Boolean.FALSE) {
                session.setAttribute("parameterlist", (Object)requestp);
                response.sendRedirect(request.getContextPath() + "/" + this.securePageName);
            } else {
                userSelectedId = (String)session.getAttribute("openid.claimed_id");
                userSelectedClaimedId = (String)session.getAttribute("openid.identity");
                authenticatedAndApproved = (Boolean)session.getAttribute("authenticatedAndApproved");
                session.removeAttribute("parameterlist");
                session.setAttribute("authenticatedAndApproved", (Object)Boolean.FALSE);
            }
            OpenIDProviderManager.OpenIDMessage responsem = this.serverManager.processAuthenticationRequest(requestp, userSelectedId, userSelectedClaimedId, authenticatedAndApproved);
            if (responsem.isSuccessful()) {
                response.sendRedirect(responsem.getDestinationURL(true));
                return;
            }
            responseText = "<pre>" + responsem.getResponseText() + "</pre>";
        } else if ("check_authentication".equals(mode)) {
            OpenIDProviderManager.OpenIDMessage responsem = this.serverManager.verify(requestp);
            responseText = responsem.getResponseText();
        } else {
            OpenIDProviderManager.OpenIDMessage responsem = this.serverManager.getDirectError("Unknown request");
            responseText = responsem.getResponseText();
        }
        this.log("[OpenIDProviderServlet]:response=" + responseText);
        response.getWriter().write(responseText);
    }
}

