/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.web.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.api.util.Base64;
import org.jboss.identity.federation.core.saml.v2.holders.DestinationInfoHolder;
import org.jboss.identity.federation.core.util.StringUtil;

public class PostBindingUtil {
    private static Logger log = Logger.getLogger(PostBindingUtil.class);
    private static boolean trace = log.isTraceEnabled();

    public static String base64Encode(String stringToEncode) throws IOException {
        return Base64.encodeBytes(stringToEncode.getBytes("UTF-8"), 8);
    }

    public static byte[] base64Decode(String encodedString) {
        if (encodedString == null) {
            throw new IllegalArgumentException("encodedString is null");
        }
        return Base64.decode(encodedString);
    }

    public static InputStream base64DecodeAsStream(String encodedString) {
        if (encodedString == null) {
            throw new IllegalArgumentException("encodedString is null");
        }
        return new ByteArrayInputStream(PostBindingUtil.base64Decode(encodedString));
    }

    public static void sendPost(DestinationInfoHolder holder, HttpServletResponse response, boolean request) throws IOException {
        String key = request ? "SAMLRequest" : "SAMLResponse";
        String relayState = holder.getRelayState();
        String destination = holder.getDestination();
        String samlMessage = holder.getSamlMessage();
        if (destination == null) {
            throw new IllegalStateException("Destination is null");
        }
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        PostBindingUtil.common(holder.getDestination(), response);
        StringBuilder builder = new StringBuilder();
        builder.append("<HTML>");
        builder.append("<HEAD>");
        if (request) {
            builder.append("<TITLE>HTTP Post Binding (Request)</TITLE>");
        } else {
            builder.append("<TITLE>HTTP Post Binding Response (Response)</TITLE>");
        }
        builder.append("</HEAD>");
        builder.append("<BODY Onload=\"document.forms[0].submit()\">");
        builder.append("<FORM METHOD=\"POST\" ACTION=\"" + destination + "\">");
        builder.append("<INPUT TYPE=\"HIDDEN\" NAME=\"" + key + "\"" + " VALUE=\"" + samlMessage + "\"/>");
        if (StringUtil.isNotNull(relayState)) {
            builder.append("<INPUT TYPE=\"HIDDEN\" NAME=\"RelayState\" VALUE=\"" + relayState + "\"/>");
        }
        builder.append("</FORM></BODY></HTML>");
        String str = builder.toString();
        if (trace) {
            log.trace((Object)str);
        }
        out.println(str);
        out.close();
    }

    private static void common(String destination, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache, no-store");
    }
}

