/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.discovery.yadis;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.xrds.XrdsParser;
import org.openid4java.discovery.yadis.YadisException;
import org.openid4java.discovery.yadis.YadisHtmlParser;
import org.openid4java.discovery.yadis.YadisResult;
import org.openid4java.discovery.yadis.YadisUrl;
import org.openid4java.util.HttpCache;
import org.openid4java.util.HttpRequestOptions;
import org.openid4java.util.HttpResponse;
import org.openid4java.util.OpenID4JavaUtils;

public class YadisResolver {
    private static Log _log = LogFactory.getLog(YadisResolver.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    public static final String YADIS_XRDS_LOCATION = "X-XRDS-Location";
    private static final String YADIS_CONTENT_TYPE = "application/xrds+xml";
    private static final String YADIS_ACCEPT_HEADER = "text/html; q=0.3, application/xhtml+xml; q=0.5, application/xrds+xml";
    private static final String YADIS_HTML_PARSER_CLASS_NAME_KEY = "discovery.yadis.html.parser";
    private static final YadisHtmlParser YADIS_HTML_PARSER;
    private static final String XRDS_PARSER_CLASS_NAME_KEY = "discovery.xrds.parser";
    private static final XrdsParser XRDS_PARSER;
    private int _maxRedirects = 10;

    public int getMaxRedirects() {
        return this._maxRedirects;
    }

    public void setMaxRedirects(int maxRedirects) {
        this._maxRedirects = maxRedirects;
    }

    public List discoverRP(String url) throws DiscoveryException {
        return this.discover(url, 0, new HttpCache(), Collections.singleton("http://specs.openid.net/auth/2.0/return_to")).getDiscoveredInformation(Collections.singleton("http://specs.openid.net/auth/2.0/return_to"));
    }

    public List discover(String url) throws DiscoveryException {
        return this.discover(url, this._maxRedirects, new HttpCache());
    }

    public List discover(String url, HttpCache cache) throws DiscoveryException {
        return this.discover(url, this._maxRedirects, cache);
    }

    public List discover(String url, int maxRedirects) throws DiscoveryException {
        return this.discover(url, maxRedirects, new HttpCache());
    }

    public List discover(String url, int maxRedirects, HttpCache cache) throws DiscoveryException {
        return this.discover(url, maxRedirects, cache, DiscoveryInformation.OPENID_OP_TYPES).getDiscoveredInformation(DiscoveryInformation.OPENID_OP_TYPES);
    }

    public YadisResult discover(String url, int maxRedirects, HttpCache cache, Set serviceTypes) throws DiscoveryException {
        YadisUrl yadisUrl = new YadisUrl(url);
        YadisResult result = this.retrieveXrdsLocation(yadisUrl, false, cache, maxRedirects, serviceTypes);
        if (result.getXrdsLocation() == null) {
            result = this.retrieveXrdsLocation(yadisUrl, true, cache, maxRedirects, serviceTypes);
        }
        if (result.getXrdsLocation() != null) {
            this.retrieveXrdsDocument(result, cache, maxRedirects, serviceTypes);
        } else if (result.hasEndpoints()) {
            result.setXrdsLocation(url, 1794);
        }
        _log.info((Object)("Yadis discovered " + result.getEndpointCount() + " endpoints from: " + url));
        return result;
    }

    private void retrieveXrdsDocument(YadisResult result, HttpCache cache, int maxRedirects, Set serviceTypes) throws DiscoveryException {
        cache.getRequestOptions().setMaxRedirects(maxRedirects);
        try {
            HttpResponse resp = cache.get(result.getXrdsLocation().toString());
            if (resp == null || 200 != resp.getStatusCode()) {
                throw new YadisException("GET failed on " + result.getXrdsLocation(), 1798);
            }
            result.setXrdsLocation(resp.getFinalUri(), 1800);
            Header contentType = resp.getResponseHeader("content-type");
            if (contentType != null && contentType.getValue() != null) {
                result.setContentType(contentType.getValue());
            }
            if (resp.isBodySizeExceeded()) {
                throw new YadisException("More than " + cache.getRequestOptions().getMaxBodySize() + " bytes in HTTP response body from " + result.getXrdsLocation(), 1806);
            }
            result.setEndpoints(XRDS_PARSER.parseXrds(resp.getBody(), serviceTypes));
        }
        catch (IOException e) {
            throw new YadisException("Fatal transport error: ", 1799, e);
        }
    }

    private String getHtmlMeta(String input) throws YadisException {
        if (input == null) {
            throw new YadisException("Cannot download HTML message", 1802);
        }
        String xrdsLocation = YADIS_HTML_PARSER.getHtmlMeta(input);
        if (DEBUG) {
            _log.debug((Object)("input:\n" + input));
            _log.debug((Object)("xrdsLocation: " + xrdsLocation));
        }
        return xrdsLocation;
    }

    private YadisResult retrieveXrdsLocation(YadisUrl url, boolean useGet, HttpCache cache, int maxRedirects, Set serviceTypes) throws DiscoveryException {
        try {
            YadisResult result = new YadisResult();
            result.setYadisUrl(url);
            if (DEBUG) {
                _log.debug((Object)("Performing HTTP " + (useGet ? "GET" : "HEAD") + " on: " + url + " ..."));
            }
            HttpRequestOptions requestOptions = cache.getRequestOptions();
            requestOptions.setMaxRedirects(maxRedirects);
            if (useGet) {
                requestOptions.addRequestHeader("Accept", YADIS_ACCEPT_HEADER);
            }
            HttpResponse resp = useGet ? cache.get(url.getUrl().toString(), requestOptions) : cache.head(url.getUrl().toString(), requestOptions);
            Header[] locationHeaders = resp.getResponseHeaders(YADIS_XRDS_LOCATION);
            Header contentType = resp.getResponseHeader("content-type");
            if (200 != resp.getStatusCode()) {
                if (useGet) {
                    throw new YadisException("GET failed on " + url + " : " + resp.getStatusCode() + ":" + resp.getStatusLine(), 1798);
                }
                if (DEBUG) {
                    _log.debug((Object)("Cannot retrieve X-XRDS-Location using HEAD from " + url.getUrl().toString() + "; status=" + resp.getStatusLine()));
                }
            } else {
                String xrdsLocation;
                if (locationHeaders != null && locationHeaders.length > 1) {
                    throw new YadisException("Found " + locationHeaders.length + " " + YADIS_XRDS_LOCATION + " headers.", useGet ? 1800 : 1797);
                }
                if (locationHeaders != null && locationHeaders.length > 0) {
                    result.setXrdsLocation(locationHeaders[0].getValue(), useGet ? 1800 : 1797);
                    result.setNormalizedUrl(resp.getFinalUri());
                } else if (contentType != null && contentType.getValue() != null && contentType.getValue().split(";")[0].equalsIgnoreCase(YADIS_CONTENT_TYPE) && resp.getBody() != null) {
                    result.setNormalizedUrl(resp.getFinalUri());
                    result.setContentType(contentType.getValue());
                    if (resp.isBodySizeExceeded()) {
                        throw new YadisException("More than " + requestOptions.getMaxBodySize() + " bytes in HTTP response body from " + url, 1806);
                    }
                    result.setEndpoints(XRDS_PARSER.parseXrds(resp.getBody(), serviceTypes));
                } else if (resp.getBody() != null && (xrdsLocation = this.getHtmlMeta(resp.getBody())) != null) {
                    result.setNormalizedUrl(resp.getFinalUri());
                    result.setXrdsLocation(xrdsLocation, 1800);
                }
            }
            return result;
        }
        catch (HttpException e) {
            throw new YadisException("HTTP error during HEAD request on: " + url, 1796, e);
        }
        catch (IOException e) {
            throw new YadisException("I/O transport error: ", 1796, e);
        }
    }

    static {
        String className = OpenID4JavaUtils.getProperty(YADIS_HTML_PARSER_CLASS_NAME_KEY);
        if (DEBUG) {
            _log.debug((Object)("discovery.yadis.html.parser:" + className));
        }
        try {
            YADIS_HTML_PARSER = (YadisHtmlParser)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        className = OpenID4JavaUtils.getProperty(XRDS_PARSER_CLASS_NAME_KEY);
        if (DEBUG) {
            _log.debug((Object)("discovery.xrds.parser:" + className));
        }
        try {
            XRDS_PARSER = (XrdsParser)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

