/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.api.saml.v2.request;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.jboss.identity.federation.api.saml.v2.request.SecurityActions;
import org.jboss.identity.federation.core.saml.v2.factories.JBossSAMLAuthnRequestFactory;
import org.jboss.identity.federation.core.saml.v2.factories.JBossSAMLBaseFactory;
import org.jboss.identity.federation.core.saml.v2.util.JAXBElementMappingUtil;
import org.jboss.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.jboss.identity.federation.saml.v2.assertion.NameIDType;
import org.jboss.identity.federation.saml.v2.profiles.xacml.protocol.XACMLAuthzDecisionQueryType;
import org.jboss.identity.federation.saml.v2.protocol.AuthnRequestType;
import org.jboss.identity.federation.saml.v2.protocol.LogoutRequestType;
import org.jboss.identity.federation.saml.v2.protocol.ObjectFactory;
import org.jboss.identity.federation.saml.v2.protocol.RequestAbstractType;

public class SAML2Request {
    public AuthnRequestType createAuthnRequestType(String id, String assertionConsumerURL, String destination, String issuerValue) throws Exception {
        return JBossSAMLAuthnRequestFactory.createAuthnRequestType((String)id, (String)assertionConsumerURL, (String)destination, (String)issuerValue);
    }

    public AuthnRequestType getAuthnRequestType(String fileName) throws Exception {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName is null");
        }
        ClassLoader tcl = SecurityActions.getContextClassLoader();
        InputStream is = tcl.getResourceAsStream(fileName);
        return this.getAuthnRequestType(is);
    }

    public RequestAbstractType getRequestType(InputStream is) throws Exception {
        if (is == null) {
            throw new IllegalStateException("InputStream is null");
        }
        Unmarshaller un = JBossSAMLAuthnRequestFactory.getValidatingUnmarshaller();
        JAXBElement jaxbAuthnRequestType = (JAXBElement)un.unmarshal(is);
        return (RequestAbstractType)jaxbAuthnRequestType.getValue();
    }

    public AuthnRequestType getAuthnRequestType(InputStream is) throws Exception {
        if (is == null) {
            throw new IllegalStateException("InputStream is null");
        }
        Unmarshaller un = JBossSAMLAuthnRequestFactory.getValidatingUnmarshaller();
        JAXBElement jaxbAuthnRequestType = (JAXBElement)un.unmarshal(is);
        return (AuthnRequestType)jaxbAuthnRequestType.getValue();
    }

    public LogoutRequestType createLogoutRequest(String issuer) throws Exception {
        ObjectFactory of = new ObjectFactory();
        LogoutRequestType lrt = of.createLogoutRequestType();
        lrt.setIssueInstant(XMLTimeUtil.getIssueInstant());
        NameIDType issuerNameID = JBossSAMLBaseFactory.createNameID();
        issuerNameID.setValue(issuer);
        lrt.setIssuer(issuerNameID);
        return lrt;
    }

    public XACMLAuthzDecisionQueryType parseXACMLDecisionQuery(String resourceName) throws Exception {
        ClassLoader tcl = SecurityActions.getContextClassLoader();
        InputStream is = tcl.getResourceAsStream(resourceName);
        return this.parseXACMLDecisionQuery(is);
    }

    public XACMLAuthzDecisionQueryType parseXACMLDecisionQuery(InputStream is) throws Exception {
        if (is == null) {
            throw new IllegalArgumentException("Inputstream is null");
        }
        String samlPath = "org.jboss.identity.federation.saml.v2.protocol";
        String xacmlPath = "org.jboss.security.xacml.core.model.context";
        String xsAssert = "org.jboss.identity.federation.saml.v2.profiles.xacml.assertion";
        String xsProto = "org.jboss.identity.federation.saml.v2.profiles.xacml.protocol";
        String path = samlPath + ":" + xacmlPath + ":" + xsAssert + ":" + xsProto;
        JAXBContext jaxb = JAXBContext.newInstance((String)path);
        Unmarshaller un = jaxb.createUnmarshaller();
        JAXBElement jaxbRequestType = (JAXBElement)un.unmarshal(is);
        RequestAbstractType req = (RequestAbstractType)jaxbRequestType.getValue();
        if (!(req instanceof XACMLAuthzDecisionQueryType)) {
            throw new IllegalStateException("Not of type XACMLAuthzDecisionQueryType");
        }
        return (XACMLAuthzDecisionQueryType)req;
    }

    public void marshall(RequestAbstractType requestType, OutputStream os) throws Exception {
        Marshaller marshaller = JBossSAMLAuthnRequestFactory.getValidatingMarshaller();
        JAXBElement j = JAXBElementMappingUtil.get((RequestAbstractType)requestType);
        marshaller.marshal((Object)j, os);
    }

    public void marshall(RequestAbstractType requestType, Writer writer) throws Exception {
        Marshaller marshaller = JBossSAMLAuthnRequestFactory.getValidatingMarshaller();
        JAXBElement j = JAXBElementMappingUtil.get((RequestAbstractType)requestType);
        marshaller.marshal((Object)j, writer);
    }
}

