/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors. 
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.identity.federation.api.wstrust;

/**
 * <p>
 * Factory class used for instantiating pluggable services, such as the {@code WSTrustRequestHandler} and
 * {@code SecurityTokenProvider} implementations.
 * </p>
 * 
 * @author <a href="mailto:sguilhen@redhat.com">Stefan Guilhen</a>
 */
public class WSTrustServiceFactory
{

   private static final WSTrustServiceFactory factory = new WSTrustServiceFactory();

   /**
    * <p>
    * Creates the {@code WSTrustConfigurationFactory} singleton instance.
    * </p>
    */
   private WSTrustServiceFactory()
   {
   }

   /**
    * <p>
    * Obtains a reference to the singleton instance.
    * </p>
    * 
    * @return the {@code WSTrustConfigurationFactory} singleton.
    */
   public static WSTrustServiceFactory getInstance()
   {
      return factory;
   }

   public WSTrustRequestHandler createRequestHandler(STSConfiguration configuration)
   {
      // TODO: obtain the actual WSTrustRequestHandler implementation class from the configuration.
      String handlerClassName = "org.jboss.identity.federation.api.wstrust.JBossWSTrustRequestHandler";
      try
      {
         Class<?> handlerClass = null;
         ClassLoader loader = Thread.currentThread().getContextClassLoader();
         if (loader == null)
            handlerClass = Class.forName(handlerClassName);
         else
            handlerClass = loader.loadClass(handlerClassName);

         // TODO: instantiate the class using a privileged block.
         WSTrustRequestHandler handler = (WSTrustRequestHandler) handlerClass.newInstance();
         handler.initialize(configuration);
         return handler;
      }
      catch (Exception e)
      {
         throw new RuntimeException(e.getMessage(), e);
      }
   }
}
