/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.api.wstrust;

import java.net.URI;
import java.security.Principal;
import java.security.PublicKey;
import org.jboss.identity.federation.api.wstrust.STSConfiguration;
import org.jboss.identity.federation.api.wstrust.SecurityTokenProvider;
import org.jboss.identity.federation.api.wstrust.WSTrustException;
import org.jboss.identity.federation.api.wstrust.WSTrustRequestContext;
import org.jboss.identity.federation.api.wstrust.WSTrustRequestHandler;
import org.jboss.identity.federation.api.wstrust.WSTrustUtil;
import org.jboss.identity.federation.core.wstrust.RequestSecurityToken;
import org.jboss.identity.federation.core.wstrust.RequestSecurityTokenResponse;
import org.jboss.identity.federation.ws.policy.AppliesTo;
import org.jboss.identity.federation.ws.trust.RequestedSecurityTokenType;

public class StandardRequestHandler
implements WSTrustRequestHandler {
    private STSConfiguration configuration;

    public void initialize(STSConfiguration configuration) {
        this.configuration = configuration;
    }

    public RequestSecurityTokenResponse issue(RequestSecurityToken request, Principal callerPrincipal) throws WSTrustException {
        String serviceName;
        SecurityTokenProvider provider = null;
        AppliesTo appliesTo = request.getAppliesTo();
        PublicKey providerPublicKey = null;
        if (appliesTo != null && (serviceName = WSTrustUtil.parseAppliesTo(appliesTo)) != null) {
            provider = this.configuration.getProviderForService(serviceName);
            request.setTokenType(URI.create(this.configuration.getTokenTypeForService(serviceName)));
            providerPublicKey = this.configuration.getServiceProviderPublicKey(serviceName);
        }
        if (provider == null && request.getTokenType() != null) {
            provider = this.configuration.getProviderForTokenType(request.getTokenType().toString());
        } else if (appliesTo == null && request.getTokenType() == null) {
            throw new WSTrustException("Either AppliesTo or TokenType must be present in a security token request");
        }
        if (provider != null) {
            WSTrustRequestContext requestContext = new WSTrustRequestContext(request, callerPrincipal);
            requestContext.setTokenIssuer(this.configuration.getSTSName());
            if (request.getLifetime() == null && this.configuration.getIssuedTokenTimeout() != 0L) {
                request.setLifetime(WSTrustUtil.createDefaultLifetime(this.configuration.getIssuedTokenTimeout()));
            }
            requestContext.setSTSKeyPair(this.configuration.getSTSKeyPair());
            requestContext.setServiceProviderPublicKey(providerPublicKey);
            provider.issueToken(requestContext);
            if (requestContext.getSecurityToken() == null) {
                throw new WSTrustException("Token issued by provider " + provider.getClass().getName() + " is null");
            }
            RequestedSecurityTokenType requestedSecurityToken = new RequestedSecurityTokenType();
            requestedSecurityToken.setAny(requestContext.getSecurityToken().getTokenValue());
            RequestSecurityTokenResponse response = new RequestSecurityTokenResponse();
            if (request.getContext() != null) {
                response.setContext(request.getContext());
            }
            response.setTokenType(request.getTokenType());
            response.setLifetime(request.getLifetime());
            response.setAppliesTo(appliesTo);
            response.setRequestedSecurityToken(requestedSecurityToken);
            if (requestContext.getAttachedReference() != null) {
                response.setRequestedAttachedReference(requestContext.getAttachedReference());
            }
            if (requestContext.getUnattachedReference() != null) {
                response.setRequestedUnattachedReference(requestContext.getUnattachedReference());
            }
            return response;
        }
        throw new WSTrustException("Unable to find a token provider for the token request");
    }

    public RequestSecurityTokenResponse renew(RequestSecurityToken request, Principal callerPrincipal) throws WSTrustException {
        throw new UnsupportedOperationException();
    }

    public RequestSecurityTokenResponse validate(RequestSecurityToken request, Principal callerPrincipal) throws WSTrustException {
        if (request.getTokenType() == null) {
            request.setTokenType(URI.create("http://docs.oasis-open.org/ws-sx/ws-trust/200512/RSTR/Status"));
        }
        SecurityTokenProvider provider = this.configuration.getProviderForTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
        WSTrustRequestContext context = new WSTrustRequestContext(request, callerPrincipal);
        context.setSTSKeyPair(this.configuration.getSTSKeyPair());
        provider.validateToken(context);
        RequestSecurityTokenResponse response = new RequestSecurityTokenResponse();
        if (request.getContext() != null) {
            response.setContext(request.getContext());
        }
        response.setTokenType(request.getTokenType());
        response.setStatus(context.getStatus());
        return response;
    }

    public RequestSecurityTokenResponse cancel(RequestSecurityToken request, Principal callerPrincipal) throws WSTrustException {
        throw new UnsupportedOperationException();
    }
}

