/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.api.wstrust;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.util.JAXBSource;
import javax.xml.transform.Source;
import org.jboss.identity.federation.core.wstrust.BaseRequestSecurityToken;
import org.jboss.identity.federation.core.wstrust.BaseRequestSecurityTokenResponse;
import org.jboss.identity.federation.core.wstrust.RequestSecurityToken;
import org.jboss.identity.federation.core.wstrust.RequestSecurityTokenCollection;
import org.jboss.identity.federation.core.wstrust.RequestSecurityTokenResponse;
import org.jboss.identity.federation.core.wstrust.RequestSecurityTokenResponseCollection;
import org.jboss.identity.federation.ws.trust.ObjectFactory;
import org.jboss.identity.federation.ws.trust.RequestSecurityTokenCollectionType;
import org.jboss.identity.federation.ws.trust.RequestSecurityTokenResponseCollectionType;
import org.jboss.identity.federation.ws.trust.RequestSecurityTokenResponseType;
import org.jboss.identity.federation.ws.trust.RequestSecurityTokenType;

public class WSTrustJAXBFactory {
    private static final WSTrustJAXBFactory instance = new WSTrustJAXBFactory();
    private final JAXBContext context;
    private final ObjectFactory factory;

    private WSTrustJAXBFactory() {
        StringBuffer packages = new StringBuffer();
        packages.append("org.jboss.identity.federation.ws.addressing");
        packages.append(":org.jboss.identity.federation.ws.policy");
        packages.append(":org.jboss.identity.federation.ws.trust");
        packages.append(":org.jboss.identity.federation.ws.wss.secext");
        packages.append(":org.jboss.identity.federation.ws.wss.utility");
        try {
            this.context = JAXBContext.newInstance((String)packages.toString());
            this.factory = new ObjectFactory();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static WSTrustJAXBFactory getInstance() {
        return instance;
    }

    public BaseRequestSecurityToken parseRequestSecurityToken(Source request) {
        try {
            Unmarshaller unmarshaller = this.context.createUnmarshaller();
            Object object = unmarshaller.unmarshal(request);
            if (object instanceof RequestSecurityTokenType) {
                return new RequestSecurityToken((RequestSecurityTokenType)object);
            }
            if (object instanceof RequestSecurityTokenCollectionType) {
                return new RequestSecurityTokenCollection((RequestSecurityTokenCollectionType)object);
            }
            if (object instanceof JAXBElement) {
                JAXBElement element = (JAXBElement)unmarshaller.unmarshal(request);
                if (element.getDeclaredType().equals(RequestSecurityTokenType.class)) {
                    return new RequestSecurityToken((RequestSecurityTokenType)element.getValue());
                }
                if (element.getDeclaredType().equals(RequestSecurityTokenCollectionType.class)) {
                    return new RequestSecurityTokenCollection((RequestSecurityTokenCollectionType)element.getValue());
                }
                throw new RuntimeException("Invalid request type: " + element.getDeclaredType());
            }
            throw new RuntimeException("Invalid request type: " + object.getClass().getName());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to unmarshall security token request", e);
        }
    }

    public BaseRequestSecurityTokenResponse parseRequestSecurityTokenResponse(Source response) {
        try {
            Unmarshaller unmarshaller = this.context.createUnmarshaller();
            Object object = unmarshaller.unmarshal(response);
            if (object instanceof RequestSecurityTokenResponseType) {
                return new RequestSecurityTokenResponse((RequestSecurityTokenResponseType)object);
            }
            if (object instanceof RequestSecurityTokenResponseCollectionType) {
                return new RequestSecurityTokenResponseCollection((RequestSecurityTokenResponseCollectionType)object);
            }
            if (object instanceof JAXBElement) {
                JAXBElement element = (JAXBElement)unmarshaller.unmarshal(response);
                if (element.getDeclaredType().equals(RequestSecurityTokenResponseType.class)) {
                    return new RequestSecurityTokenResponse((RequestSecurityTokenResponseType)element.getValue());
                }
                if (element.getDeclaredType().equals(RequestSecurityTokenResponseCollectionType.class)) {
                    return new RequestSecurityTokenResponseCollection((RequestSecurityTokenResponseCollectionType)element.getValue());
                }
                throw new RuntimeException("Invalid response type: " + element.getDeclaredType());
            }
            throw new RuntimeException("Invalid response type: " + object.getClass().getName());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to unmarshall security token response", e);
        }
    }

    public Source marshallRequestSecurityToken(BaseRequestSecurityToken request) {
        JAXBElement element = null;
        if (request instanceof RequestSecurityToken) {
            RequestSecurityToken requestSecurityToken = (RequestSecurityToken)request;
            element = this.factory.createRequestSecurityToken(requestSecurityToken.getDelegate());
        } else if (request instanceof RequestSecurityTokenCollection) {
            RequestSecurityTokenCollection collection = (RequestSecurityTokenCollection)request;
            element = this.factory.createRequestSecurityTokenCollection(collection.getDelegate());
        } else {
            throw new RuntimeException("Failed to determine the type of the security token request");
        }
        try {
            Marshaller marshaller = this.context.createMarshaller();
            return new JAXBSource(marshaller, (Object)element);
        }
        catch (JAXBException je) {
            throw new RuntimeException("Failed to marshall security token request", je);
        }
    }

    public Source marshallRequestSecurityTokenResponse(BaseRequestSecurityTokenResponse response) {
        JAXBElement element = null;
        if (response instanceof RequestSecurityTokenResponse) {
            RequestSecurityTokenResponse requestSecurityTokenResponse = (RequestSecurityTokenResponse)response;
            element = this.factory.createRequestSecurityTokenResponse(requestSecurityTokenResponse.getDelegate());
        } else if (response instanceof RequestSecurityTokenResponseCollection) {
            RequestSecurityTokenResponseCollection collection = (RequestSecurityTokenResponseCollection)response;
            element = this.factory.createRequestSecurityTokenResponseCollection(collection.getDelegate());
        } else {
            throw new RuntimeException("Failed to determine the type of the security token response");
        }
        try {
            Marshaller marshaller = this.context.createMarshaller();
            return new JAXBSource(marshaller, (Object)element);
        }
        catch (JAXBException je) {
            throw new RuntimeException("Failed to marshall security token request", je);
        }
    }
}

