/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.api.wstrust;

import java.security.PrivilegedActionException;
import org.jboss.identity.federation.api.wstrust.STSConfiguration;
import org.jboss.identity.federation.api.wstrust.SecurityActions;
import org.jboss.identity.federation.api.wstrust.SecurityTokenProvider;
import org.jboss.identity.federation.api.wstrust.WSTrustRequestHandler;

public class WSTrustServiceFactory {
    private static final WSTrustServiceFactory factory = new WSTrustServiceFactory();

    private WSTrustServiceFactory() {
    }

    public static WSTrustServiceFactory getInstance() {
        return factory;
    }

    public WSTrustRequestHandler createRequestHandler(String handlerClassName, STSConfiguration configuration) {
        try {
            WSTrustRequestHandler handler = (WSTrustRequestHandler)SecurityActions.instantiateClass(handlerClassName);
            handler.initialize(configuration);
            return handler;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public SecurityTokenProvider createTokenProvider(String providerClass) {
        try {
            SecurityTokenProvider tokenProvider = (SecurityTokenProvider)SecurityActions.instantiateClass(providerClass);
            return tokenProvider;
        }
        catch (PrivilegedActionException pae) {
            throw new RuntimeException("Unable to instantiate token provider " + providerClass, pae);
        }
    }
}

