/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.api.wstrust.plugins.saml;

import java.net.URI;
import java.security.KeyPair;
import java.security.Principal;
import java.util.HashMap;
import java.util.UUID;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.jboss.identity.federation.api.util.XMLSignatureUtil;
import org.jboss.identity.federation.api.wstrust.SecurityTokenProvider;
import org.jboss.identity.federation.api.wstrust.StandardSecurityToken;
import org.jboss.identity.federation.api.wstrust.WSTrustException;
import org.jboss.identity.federation.api.wstrust.WSTrustRequestContext;
import org.jboss.identity.federation.api.wstrust.WSTrustUtil;
import org.jboss.identity.federation.api.wstrust.plugins.saml.SAMLUtil;
import org.jboss.identity.federation.core.exceptions.ConfigurationException;
import org.jboss.identity.federation.core.saml.v2.factories.SAMLAssertionFactory;
import org.jboss.identity.federation.core.saml.v2.util.AssertionUtil;
import org.jboss.identity.federation.core.wstrust.Lifetime;
import org.jboss.identity.federation.saml.v2.assertion.AssertionType;
import org.jboss.identity.federation.saml.v2.assertion.AudienceRestrictionType;
import org.jboss.identity.federation.saml.v2.assertion.ConditionAbstractType;
import org.jboss.identity.federation.saml.v2.assertion.ConditionsType;
import org.jboss.identity.federation.saml.v2.assertion.NameIDType;
import org.jboss.identity.federation.saml.v2.assertion.SubjectConfirmationType;
import org.jboss.identity.federation.saml.v2.assertion.SubjectType;
import org.jboss.identity.federation.ws.policy.AppliesTo;
import org.jboss.identity.federation.ws.trust.RequestedReferenceType;
import org.jboss.identity.federation.ws.trust.StatusType;
import org.jboss.identity.federation.ws.trust.ValidateTargetType;
import org.jboss.identity.federation.ws.wss.secext.KeyIdentifierType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SAML20TokenProvider
implements SecurityTokenProvider {
    public void cancelToken(WSTrustRequestContext context) throws WSTrustException {
    }

    public void issueToken(WSTrustRequestContext context) throws WSTrustException {
        String assertionID = "ID-" + UUID.randomUUID().toString();
        Lifetime lifetime = context.getRequestSecurityToken().getLifetime();
        AudienceRestrictionType restriction = null;
        AppliesTo appliesTo = context.getRequestSecurityToken().getAppliesTo();
        if (appliesTo != null) {
            restriction = SAMLAssertionFactory.createAudienceRestriction((String[])new String[]{WSTrustUtil.parseAppliesTo(appliesTo)});
        }
        ConditionsType conditions = SAMLAssertionFactory.createConditions((XMLGregorianCalendar)lifetime.getCreated(), (XMLGregorianCalendar)lifetime.getExpires(), (ConditionAbstractType[])new ConditionAbstractType[]{restriction});
        String confirmationMethod = "urn:oasis:names:tc:SAML:2.0:cm:bearer";
        SubjectConfirmationType subjectConfirmation = SAMLAssertionFactory.createSubjectConfirmation(null, (String)confirmationMethod, null);
        Principal principal = context.getCallerPrincipal();
        String subjectName = principal == null ? "ANONYMOUS" : principal.getName();
        NameIDType nameID = SAMLAssertionFactory.createNameID(null, (String)"urn:jboss:identity-federation", (String)subjectName);
        SubjectType subject = SAMLAssertionFactory.createSubject((NameIDType)nameID, (SubjectConfirmationType)subjectConfirmation);
        NameIDType issuerID = SAMLAssertionFactory.createNameID(null, null, (String)context.getTokenIssuer());
        AssertionType assertion = SAMLAssertionFactory.createAssertion((String)assertionID, (NameIDType)issuerID, (XMLGregorianCalendar)lifetime.getCreated(), (ConditionsType)conditions, (SubjectType)subject, null);
        Document document = null;
        try {
            document = SAMLUtil.toDocument(assertion);
        }
        catch (Exception e) {
            throw new WSTrustException("Failed to marshall SAMLV2 assertion", e);
        }
        KeyPair keyPair = context.getSTSKeyPair();
        if (keyPair != null) {
            URI signatureURI = context.getRequestSecurityToken().getSignatureAlgorithm();
            String signatureMethod = signatureURI != null ? signatureURI.toString() : "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
            try {
                XMLSignatureUtil.sign(document, keyPair, "http://www.w3.org/2000/09/xmldsig#sha1", signatureMethod, "#" + assertionID);
            }
            catch (Exception e) {
                throw new WSTrustException("Failed to sign SAMLV2 assertion", e);
            }
        }
        StandardSecurityToken token = new StandardSecurityToken(context.getRequestSecurityToken().getTokenType().toString(), document.getDocumentElement(), assertionID);
        context.setSecurityToken(token);
        KeyIdentifierType keyIdentifier = WSTrustUtil.createKeyIdentifier("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID", "#" + assertionID);
        HashMap<QName, String> attributes = new HashMap<QName, String>();
        attributes.put(new QName("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "TokenType"), "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
        RequestedReferenceType attachedReference = WSTrustUtil.createRequestedReference(keyIdentifier, attributes);
        context.setAttachedReference(attachedReference);
    }

    public void renewToken(WSTrustRequestContext context) throws WSTrustException {
    }

    public void validateToken(WSTrustRequestContext context) throws WSTrustException {
        ValidateTargetType validateTarget = context.getRequestSecurityToken().getValidateTarget();
        if (validateTarget == null) {
            throw new WSTrustException("Invalid validate message: missing required ValidateTarget");
        }
        Element assertionElement = (Element)validateTarget.getAny();
        String code = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/valid";
        String reason = "SAMLV2.0 Assertion successfuly validated";
        if (!this.isAssertion(assertionElement)) {
            code = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/invalid";
            reason = "Validation failure: supplied token is not a SAMLV2.0 Assertion";
        } else {
            AssertionType assertion = null;
            KeyPair keyPair = context.getSTSKeyPair();
            try {
                assertion = SAMLUtil.fromDocument(assertionElement.getOwnerDocument());
                if (!XMLSignatureUtil.validate(SAMLUtil.toDocument(assertion), keyPair.getPublic())) {
                    code = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/invalid";
                    reason = "Validation failure: digital signature is invalid";
                }
            }
            catch (Exception e) {
                code = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/invalid";
                reason = "Validation failure: unable to verify digital signature: " + e.getMessage();
            }
            try {
                if (AssertionUtil.hasExpired((AssertionType)assertion)) {
                    code = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/invalid";
                    reason = "Validation failure: assertion expired or used before its lifetime period";
                }
            }
            catch (ConfigurationException ce) {
                code = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/invalid";
                reason = "Validation failure: unable to verify assertion lifetime: " + ce.getMessage();
            }
        }
        StatusType status = new StatusType();
        status.setCode(code);
        status.setReason(reason);
        context.setStatus(status);
    }

    private boolean isAssertion(Element element) {
        return element == null ? false : "Assertion".equals(element.getLocalName()) && "urn:oasis:names:tc:SAML:2.0:assertion".equals(element.getNamespaceURI());
    }
}

