/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.api.wstrust.plugins.saml;

import com.sun.xml.bind.marshaller.NamespacePrefixMapper;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.jboss.identity.federation.saml.v2.assertion.AssertionType;
import org.jboss.identity.federation.saml.v2.assertion.ObjectFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SAMLUtil {
    public static final String SAML2_BEARER_URI = "urn:oasis:names:tc:SAML:2.0:cm:bearer";
    public static final String SAML2_TOKEN_TYPE = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0";
    public static final String SAML2_VALUE_TYPE = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID";

    public static Document toDocument(AssertionType assertion) throws Exception {
        Document document = null;
        document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        DOMResult result = new DOMResult(document);
        JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.jboss.identity.federation.saml.v2.assertion");
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new DefaultPrefixMapper());
        marshaller.marshal((Object)new ObjectFactory().createAssertion(assertion), (Result)result);
        return document;
    }

    public static AssertionType fromDocument(Document document) throws JAXBException {
        JAXBElement element;
        JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.jboss.identity.federation.saml.v2.assertion");
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        Object object = unmarshaller.unmarshal((Node)document);
        if (object instanceof AssertionType) {
            return (AssertionType)object;
        }
        if (object instanceof JAXBElement && (element = (JAXBElement)object).getDeclaredType().equals(AssertionType.class)) {
            return (AssertionType)element.getValue();
        }
        throw new IllegalArgumentException("Supplied document does not contain a SAMLV2.0 Assertion");
    }

    static class DefaultPrefixMapper
    extends NamespacePrefixMapper {
        DefaultPrefixMapper() {
        }

        public String getPreferredPrefix(String namespaceURI, String suggestion, boolean requirePrefix) {
            if ("http://www.w3.org/2005/08/addressing".equals(namespaceURI)) {
                return "wsa";
            }
            if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd".equals(namespaceURI)) {
                return "wsu";
            }
            if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(namespaceURI)) {
                return "wsse";
            }
            if ("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd".equals(namespaceURI)) {
                return "wsse11";
            }
            if ("http://www.w3.org/2001/04/xmlenc#".equals(namespaceURI)) {
                return "xenc";
            }
            if ("http://www.w3.org/2000/09/xmldsig#".equals(namespaceURI)) {
                return "ds";
            }
            if ("urn:oasis:names:tc:SAML:2.0:assertion".equals(namespaceURI)) {
                return "saml2";
            }
            return null;
        }
    }
}

