/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.api.soap;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.jboss.identity.federation.core.exceptions.ConfigurationException;
import org.jboss.identity.federation.core.exceptions.ProcessingException;
import org.jboss.identity.federation.core.factories.SOAPFactory;
import org.jboss.identity.federation.core.saml.v2.factories.SAMLAssertionFactory;
import org.jboss.identity.federation.core.saml.v2.util.SOAPSAMLXACMLUtil;
import org.jboss.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.jboss.identity.federation.org.xmlsoap.schemas.soap.envelope.Body;
import org.jboss.identity.federation.org.xmlsoap.schemas.soap.envelope.Envelope;
import org.jboss.identity.federation.org.xmlsoap.schemas.soap.envelope.Fault;
import org.jboss.identity.federation.saml.v2.assertion.AssertionType;
import org.jboss.identity.federation.saml.v2.assertion.NameIDType;
import org.jboss.identity.federation.saml.v2.profiles.xacml.assertion.XACMLAuthzDecisionStatementType;
import org.jboss.identity.federation.saml.v2.profiles.xacml.protocol.XACMLAuthzDecisionQueryType;
import org.jboss.identity.federation.saml.v2.protocol.ResponseType;
import org.jboss.security.xacml.core.model.context.DecisionType;
import org.jboss.security.xacml.core.model.context.RequestType;
import org.jboss.security.xacml.core.model.context.ResultType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPSAMLXACML {
    public Result send(String endpoint, String issuer, RequestType xacmlRequest) throws ProcessingException {
        try {
            XACMLAuthzDecisionQueryType queryType = SOAPSAMLXACMLUtil.createXACMLAuthzDecisionQueryType();
            queryType.setRequest(xacmlRequest);
            queryType.setIssueInstant(XMLTimeUtil.getIssueInstant());
            NameIDType nameIDType = SAMLAssertionFactory.getObjectFactory().createNameIDType();
            nameIDType.setValue(issuer);
            queryType.setIssuer(nameIDType);
            JAXBElement jaxbQueryType = SOAPSAMLXACMLUtil.getJAXB((XACMLAuthzDecisionQueryType)queryType);
            Envelope envelope = this.createEnvelope(jaxbQueryType);
            JAXBElement soapRequest = SOAPFactory.getObjectFactory().createEnvelope(envelope);
            Marshaller marshaller = SOAPSAMLXACMLUtil.getMarshaller();
            Unmarshaller unmarshaller = SOAPSAMLXACMLUtil.getUnmarshaller();
            URL url = new URL(endpoint);
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            marshaller.marshal((Object)soapRequest, conn.getOutputStream());
            JAXBElement result = (JAXBElement)unmarshaller.unmarshal(conn.getInputStream());
            Envelope resultEnvelope = (Envelope)result.getValue();
            JAXBElement samlResponse = (JAXBElement)resultEnvelope.getBody().getAny().get(0);
            Object response = samlResponse.getValue();
            if (response instanceof Fault) {
                Fault fault = (Fault)response;
                return new Result(null, fault);
            }
            ResponseType responseType = (ResponseType)response;
            AssertionType at = (AssertionType)responseType.getAssertionOrEncryptedAssertion().get(0);
            XACMLAuthzDecisionStatementType xst = (XACMLAuthzDecisionStatementType)at.getStatementOrAuthnStatementOrAuthzDecisionStatement().get(0);
            ResultType rt = (ResultType)xst.getResponse().getResult().get(0);
            DecisionType dt = rt.getDecision();
            return new Result(dt, null);
        }
        catch (JAXBException e) {
            throw new ProcessingException((Throwable)e);
        }
        catch (IOException e) {
            throw new ProcessingException((Throwable)e);
        }
        catch (ConfigurationException e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    private Envelope createEnvelope(JAXBElement<?> jaxbElement) {
        Envelope envelope = SOAPFactory.getObjectFactory().createEnvelope();
        Body body = SOAPFactory.getObjectFactory().createBody();
        body.getAny().add(jaxbElement);
        envelope.setBody(body);
        return envelope;
    }

    public class Result {
        private Fault fault = null;
        private DecisionType decisionType;

        Result(DecisionType decision, Fault fault) {
            this.decisionType = decision;
            this.fault = fault;
        }

        public boolean isResponseAvailable() {
            return this.decisionType != null;
        }

        public boolean isFault() {
            return this.fault != null;
        }

        public DecisionType getDecision() {
            return this.decisionType;
        }

        public Fault getFault() {
            return this.fault;
        }

        public boolean isPermit() {
            return this.decisionType == DecisionType.PERMIT;
        }

        public boolean isDeny() {
            return this.decisionType == DecisionType.DENY;
        }
    }
}

