/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.web.servlets;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PublicKey;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.core.exceptions.ConfigurationException;
import org.jboss.identity.federation.core.exceptions.ParsingException;
import org.jboss.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.jboss.identity.federation.core.saml.v2.exceptions.IssueInstantMissingException;
import org.jboss.identity.federation.core.saml.v2.exceptions.IssuerNotTrustedException;
import org.jboss.identity.federation.saml.v2.protocol.AuthnRequestType;
import org.jboss.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.jboss.identity.federation.web.config.IDPType;
import org.jboss.identity.federation.web.config.KeyProviderType;
import org.jboss.identity.federation.web.interfaces.RoleGenerator;
import org.jboss.identity.federation.web.interfaces.TrustKeyConfigurationException;
import org.jboss.identity.federation.web.interfaces.TrustKeyManager;
import org.jboss.identity.federation.web.interfaces.TrustKeyProcessingException;
import org.jboss.identity.federation.web.roles.DefaultRoleGenerator;
import org.jboss.identity.federation.web.servlets.SecurityActions;
import org.jboss.identity.federation.web.util.ConfigurationUtil;
import org.jboss.identity.federation.web.util.IDPWebRequestUtil;
import org.jboss.identity.federation.web.util.RedirectBindingSignatureUtil;
import org.w3c.dom.Document;

public class IDPServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(IDPServlet.class);
    private boolean trace = log.isTraceEnabled();
    public static final String PRINCIPAL_ID = "jboss_identity.principal";
    public static final String ROLES_ID = "jboss_identity.roles";
    protected IDPType idpConfiguration = null;
    private RoleGenerator rg = new DefaultRoleGenerator();
    private long assertionValidity = 5000L;
    private String identityURL = null;
    private TrustKeyManager keyManager;
    private Boolean ignoreIncomingSignatures = true;
    private Boolean signOutgoingMessages = true;
    private ServletContext context = null;

    public Boolean getIgnoreIncomingSignatures() {
        return this.ignoreIncomingSignatures;
    }

    public void init(ServletConfig config) throws ServletException {
        String rgString;
        super.init(config);
        String configFile = "/WEB-INF/jboss-idfed.xml";
        this.context = config.getServletContext();
        InputStream is = this.context.getResourceAsStream(configFile);
        if (is == null) {
            throw new RuntimeException(configFile + " missing");
        }
        try {
            this.idpConfiguration = ConfigurationUtil.getIDPConfiguration(is);
            this.identityURL = this.idpConfiguration.getIdentityURL();
            log.trace((Object)("Identity Provider URL=" + this.identityURL));
            this.assertionValidity = this.idpConfiguration.getAssertionValidity();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.signOutgoingMessages.booleanValue()) {
            KeyProviderType keyProvider = this.idpConfiguration.getKeyProvider();
            if (keyProvider == null) {
                throw new RuntimeException("Key Provider is null for context=" + this.context.getContextPath());
            }
            try {
                ClassLoader tcl = SecurityActions.getContextClassLoader();
                String keyManagerClassName = keyProvider.getClassName();
                if (keyManagerClassName == null) {
                    throw new RuntimeException("KeyManager class name is null");
                }
                Class<?> clazz = tcl.loadClass(keyManagerClassName);
                this.keyManager = (TrustKeyManager)clazz.newInstance();
                this.keyManager.setAuthProperties(keyProvider.getAuth());
                this.keyManager.setValidatingAlias(keyProvider.getValidatingAlias());
            }
            catch (Exception e) {
                log.error((Object)"Exception reading configuration:", (Throwable)e);
                throw new RuntimeException(e.getLocalizedMessage());
            }
            if (this.trace) {
                log.trace((Object)("Key Provider=" + keyProvider.getClassName()));
            }
        }
        if ((rgString = config.getInitParameter("ROLE_GENERATOR")) != null && !"".equals(rgString)) {
            this.setRoleGenerator(rgString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block63: {
            HttpSession session = request.getSession(false);
            String samlMessage = (String)session.getAttribute("SAMLRequest");
            String relayState = (String)session.getAttribute("RelayState");
            String referer = request.getHeader("Referer");
            Principal userPrincipal = (Principal)session.getAttribute(PRINCIPAL_ID);
            if (userPrincipal == null) {
                if (this.trace) {
                    log.trace((Object)"Login Filters have not been configured");
                }
                response.sendError(500);
            }
            IDPWebRequestUtil webRequestUtil = new IDPWebRequestUtil(request, this.idpConfiguration, this.keyManager);
            if (userPrincipal != null) {
                if (this.trace) {
                    log.trace((Object)"Retrieved saml message and relay state from session");
                    log.trace((Object)("saml message=" + samlMessage + "::relay state=" + relayState));
                }
                session.removeAttribute("SAMLRequest");
                if (relayState != null && relayState.length() > 0) {
                    session.removeAttribute("RelayState");
                }
                if (samlMessage != null) {
                    block61: {
                        RequestAbstractType requestAbstractType = null;
                        Document samlResponse = null;
                        String destination = null;
                        requestAbstractType = webRequestUtil.getSAMLRequest(samlMessage);
                        boolean isPost = webRequestUtil.hasSAMLRequestInPostProfile();
                        boolean isValid = this.validate(request.getRemoteAddr(), request.getQueryString(), new SessionHolder(samlMessage, null, null), isPost);
                        if (!isValid) {
                            throw new GeneralSecurityException("Validation check failed");
                        }
                        webRequestUtil.isTrusted(requestAbstractType.getIssuer().getValue());
                        List<String> roles = (List<String>)session.getAttribute(ROLES_ID);
                        if (roles == null) {
                            roles = this.rg.generateRoles(userPrincipal);
                            session.setAttribute(ROLES_ID, roles);
                        }
                        if (this.trace) {
                            log.trace((Object)"Roles have been determined:Creating response");
                        }
                        AuthnRequestType art = (AuthnRequestType)requestAbstractType;
                        destination = art.getAssertionConsumerServiceURL();
                        samlResponse = webRequestUtil.getResponse(destination, userPrincipal, roles, this.identityURL, this.assertionValidity, this.signOutgoingMessages);
                        Object var17_22 = null;
                        try {
                            if (this.signOutgoingMessages.booleanValue()) {
                                webRequestUtil.send(samlResponse, destination, relayState, response, true, this.keyManager.getSigningKey());
                                break block61;
                            }
                            webRequestUtil.send(samlResponse, destination, relayState, response, false, null);
                        }
                        catch (ParsingException e2) {
                            if (this.trace) {
                                log.trace((Object)e2);
                            }
                            break block61;
                        }
                        catch (GeneralSecurityException e3) {
                            if (this.trace) {
                                log.trace((Object)e3);
                            }
                            break block61;
                        }
                        {
                            catch (IssuerNotTrustedException e) {
                                if (this.trace) {
                                    log.trace((Object)e);
                                }
                                samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_REQUEST_DENIED.get(), this.identityURL, this.signOutgoingMessages);
                                Object var17_23 = null;
                                try {
                                    if (this.signOutgoingMessages.booleanValue()) {
                                        webRequestUtil.send(samlResponse, destination, relayState, response, true, this.keyManager.getSigningKey());
                                        break block61;
                                    }
                                    webRequestUtil.send(samlResponse, destination, relayState, response, false, null);
                                }
                                catch (ParsingException e2) {
                                    if (this.trace) {
                                        log.trace((Object)e2);
                                    }
                                    break block61;
                                }
                                catch (GeneralSecurityException e3) {
                                    if (this.trace) {
                                        log.trace((Object)e3);
                                    }
                                    break block61;
                                }
                            }
                            catch (ParsingException e) {
                                if (this.trace) {
                                    log.trace((Object)e);
                                }
                                samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL, this.signOutgoingMessages);
                                Object var17_24 = null;
                                try {
                                    if (this.signOutgoingMessages.booleanValue()) {
                                        webRequestUtil.send(samlResponse, destination, relayState, response, true, this.keyManager.getSigningKey());
                                        break block61;
                                    }
                                    webRequestUtil.send(samlResponse, destination, relayState, response, false, null);
                                }
                                catch (ParsingException e2) {
                                    if (this.trace) {
                                        log.trace((Object)e2);
                                    }
                                    break block61;
                                }
                                catch (GeneralSecurityException e3) {
                                    if (this.trace) {
                                        log.trace((Object)e3);
                                    }
                                    break block61;
                                }
                            }
                            catch (ConfigurationException e) {
                                if (this.trace) {
                                    log.trace((Object)e);
                                }
                                samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL, this.signOutgoingMessages);
                                Object var17_25 = null;
                                try {
                                    if (this.signOutgoingMessages.booleanValue()) {
                                        webRequestUtil.send(samlResponse, destination, relayState, response, true, this.keyManager.getSigningKey());
                                        break block61;
                                    }
                                    webRequestUtil.send(samlResponse, destination, relayState, response, false, null);
                                }
                                catch (ParsingException e2) {
                                    if (this.trace) {
                                        log.trace((Object)e2);
                                    }
                                    break block61;
                                }
                                catch (GeneralSecurityException e3) {
                                    if (this.trace) {
                                        log.trace((Object)e3);
                                    }
                                    break block61;
                                }
                            }
                            catch (IssueInstantMissingException e) {
                                if (this.trace) {
                                    log.trace((Object)e);
                                }
                                samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL, this.signOutgoingMessages);
                                Object var17_26 = null;
                                try {
                                    if (this.signOutgoingMessages.booleanValue()) {
                                        webRequestUtil.send(samlResponse, destination, relayState, response, true, this.keyManager.getSigningKey());
                                        break block61;
                                    }
                                    webRequestUtil.send(samlResponse, destination, relayState, response, false, null);
                                }
                                catch (ParsingException e2) {
                                    if (this.trace) {
                                        log.trace((Object)e2);
                                    }
                                    break block61;
                                }
                                catch (GeneralSecurityException e3) {
                                    if (this.trace) {
                                        log.trace((Object)e3);
                                    }
                                    break block61;
                                }
                            }
                            catch (GeneralSecurityException e) {
                                if (this.trace) {
                                    log.trace((Object)e);
                                }
                                samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL, this.signOutgoingMessages);
                                Object var17_27 = null;
                                try {
                                    if (this.signOutgoingMessages.booleanValue()) {
                                        webRequestUtil.send(samlResponse, destination, relayState, response, true, this.keyManager.getSigningKey());
                                        break block61;
                                    }
                                    webRequestUtil.send(samlResponse, destination, relayState, response, false, null);
                                }
                                catch (ParsingException e2) {
                                    if (this.trace) {
                                        log.trace((Object)e2);
                                    }
                                    break block61;
                                }
                                catch (GeneralSecurityException e3) {
                                    if (this.trace) {
                                        log.trace((Object)e3);
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            block62: {
                                Object var17_28 = null;
                                try {
                                    if (this.signOutgoingMessages.booleanValue()) {
                                        webRequestUtil.send(samlResponse, destination, relayState, response, true, this.keyManager.getSigningKey());
                                    } else {
                                        webRequestUtil.send(samlResponse, destination, relayState, response, false, null);
                                    }
                                }
                                catch (ParsingException e2) {
                                    if (this.trace) {
                                        log.trace((Object)e2);
                                    }
                                }
                                catch (GeneralSecurityException e3) {
                                    if (!this.trace) break block62;
                                    log.trace((Object)e3);
                                }
                            }
                            throw throwable;
                        }
                    }
                    return;
                }
                log.error((Object)"No SAML Request Message");
                if (this.trace) {
                    log.trace((Object)("Referer=" + referer));
                }
                try {
                    this.sendErrorResponseToSP(referer, response, relayState, webRequestUtil);
                }
                catch (ConfigurationException e) {
                    if (!this.trace) break block63;
                    log.trace((Object)e);
                }
            }
        }
    }

    protected void sendErrorResponseToSP(String referrer, HttpServletResponse response, String relayState, IDPWebRequestUtil webRequestUtil) throws ServletException, IOException, ConfigurationException {
        if (this.trace) {
            log.trace((Object)("About to send error response to SP:" + referrer));
        }
        Document samlResponse = webRequestUtil.getErrorResponse(referrer, JBossSAMLURIConstants.STATUS_RESPONDER.get(), this.identityURL, this.signOutgoingMessages);
        try {
            if (this.signOutgoingMessages.booleanValue()) {
                webRequestUtil.send(samlResponse, referrer, relayState, response, true, this.keyManager.getSigningKey());
            } else {
                webRequestUtil.send(samlResponse, referrer, relayState, response, false, null);
            }
        }
        catch (ParsingException e1) {
            throw new ServletException((Throwable)e1);
        }
        catch (GeneralSecurityException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.sendError(405);
    }

    protected boolean validate(String remoteAddress, String queryString, SessionHolder holder, boolean isPost) throws IOException, GeneralSecurityException {
        if (holder.samlRequest == null || holder.samlRequest.length() == 0) {
            return false;
        }
        if (!this.ignoreIncomingSignatures.booleanValue() && !isPost) {
            PublicKey validatingKey;
            String sig = holder.signature;
            if (sig == null || sig.length() == 0) {
                log.error((Object)("Signature received from SP is null:" + remoteAddress));
                return false;
            }
            byte[] sigValue = RedirectBindingSignatureUtil.getSignatureValueFromSignedURL(queryString);
            if (sigValue == null) {
                return false;
            }
            try {
                validatingKey = this.keyManager.getValidatingKey(remoteAddress);
            }
            catch (TrustKeyConfigurationException e) {
                throw new GeneralSecurityException(e.getCause());
            }
            catch (TrustKeyProcessingException e) {
                throw new GeneralSecurityException(e.getCause());
            }
            return RedirectBindingSignatureUtil.validateSignature(queryString, validatingKey, sigValue);
        }
        return true;
    }

    private void setRoleGenerator(String rgName) {
        try {
            Class<?> clazz = SecurityActions.getContextClassLoader().loadClass(rgName);
            this.rg = (RoleGenerator)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected class SessionHolder {
        String samlRequest;
        String signature;
        String sigAlg;

        public SessionHolder(String req, String sig, String alg) {
            this.samlRequest = req;
            this.signature = sig;
            this.sigAlg = alg;
        }
    }
}

