/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.web.handlers.saml2;

import java.security.Principal;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.jboss.identity.federation.core.exceptions.ProcessingException;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.jboss.identity.federation.saml.v2.protocol.LogoutRequestType;
import org.jboss.identity.federation.web.core.HTTPContext;
import org.jboss.identity.federation.web.handlers.saml2.BaseSAML2Handler;
import org.jboss.identity.federation.web.handlers.saml2.SecurityActions;
import org.jboss.identity.federation.web.interfaces.RoleGenerator;
import org.jboss.identity.federation.web.roles.DefaultRoleGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolesGenerationHandler
extends BaseSAML2Handler {
    private transient RoleGenerator rg = new DefaultRoleGenerator();

    @Override
    public void init(Map<String, Object> options) {
        super.init(options);
        if (options.containsKey("ROLE_GENERATOR")) {
            String clazzName = (String)options.get("ROLE_GENERATOR");
            ClassLoader tcl = SecurityActions.getContextClassLoader();
            try {
                this.rg = (RoleGenerator)tcl.loadClass(clazzName).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to instantiate Role Generator:", e);
            }
        }
    }

    public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (request.getSAML2Object() instanceof LogoutRequestType) {
            return;
        }
        if (request.getType() == SAML2HandlerRequest.HANDLER_TYPE.SP) {
            return;
        }
        HTTPContext httpContext = (HTTPContext)request.getContext();
        HttpSession session = httpContext.getRequest().getSession(false);
        Principal userPrincipal = (Principal)session.getAttribute("jboss_identity.principal");
        List<String> roles = (List<String>)session.getAttribute("jboss_identity.roles");
        if (roles == null) {
            RoleGenerator rg = (RoleGenerator)request.getOptions().get("ROLE_GENERATOR");
            roles = rg.generateRoles(userPrincipal);
            session.setAttribute("jboss_identity.roles", roles);
        }
        response.setRoles((List)roles);
    }

    public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
    }

    public void generateSAMLRequest(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
    }

    public void reset() throws ProcessingException {
    }
}

