/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.web.handlers.saml2;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.identity.federation.core.config.IDPType;
import org.jboss.identity.federation.core.exceptions.ConfigurationException;
import org.jboss.identity.federation.core.exceptions.ProcessingException;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2HandlerChainConfig;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2HandlerConfig;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.jboss.identity.federation.web.core.HTTPContext;

public abstract class BaseSAML2Handler
implements SAML2Handler {
    protected SAML2HandlerConfig handlerConfig = null;
    protected SAML2HandlerChainConfig handlerChainConfig = null;
    protected SAML2Handler.HANDLER_TYPE handlerType;

    public void initHandlerConfig(SAML2HandlerConfig handlerConfig) throws ConfigurationException {
        this.handlerConfig = handlerConfig;
    }

    public void initChainConfig(SAML2HandlerChainConfig handlerChainConfig) throws ConfigurationException {
        this.handlerChainConfig = handlerChainConfig;
        Object config = this.handlerChainConfig.getParameter("CONFIGURATION");
        this.handlerType = config instanceof IDPType ? SAML2Handler.HANDLER_TYPE.IDP : SAML2Handler.HANDLER_TYPE.SP;
    }

    public SAML2Handler.HANDLER_TYPE getType() {
        return this.handlerType;
    }

    public void reset() throws ProcessingException {
    }

    public void generateSAMLRequest(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
    }

    public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
    }

    public static HttpServletRequest getHttpRequest(SAML2HandlerRequest request) {
        HTTPContext context = (HTTPContext)request.getContext();
        return context.getRequest();
    }

    public static HttpSession getHttpSession(SAML2HandlerRequest request) {
        HTTPContext context = (HTTPContext)request.getContext();
        return context.getRequest().getSession(false);
    }
}

