/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.web.handlers.saml2;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.core.config.IDPType;
import org.jboss.identity.federation.core.exceptions.ConfigurationException;
import org.jboss.identity.federation.core.exceptions.ProcessingException;
import org.jboss.identity.federation.core.impl.EmptyAttributeManager;
import org.jboss.identity.federation.core.interfaces.AttributeManager;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2HandlerChainConfig;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2HandlerConfig;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.jboss.identity.federation.saml.v2.protocol.LogoutRequestType;
import org.jboss.identity.federation.web.core.HTTPContext;
import org.jboss.identity.federation.web.handlers.saml2.BaseSAML2Handler;
import org.jboss.identity.federation.web.handlers.saml2.SecurityActions;

public class SAML2AttributeHandler
extends BaseSAML2Handler {
    private static Logger log = Logger.getLogger(SAML2AttributeHandler.class);
    private boolean trace = log.isTraceEnabled();
    protected AttributeManager attribManager = new EmptyAttributeManager();
    protected List<String> attributeKeys = new ArrayList<String>();

    public void initChainConfig(SAML2HandlerChainConfig handlerChainConfig) throws ConfigurationException {
        super.initChainConfig(handlerChainConfig);
        Object config = this.handlerChainConfig.getParameter("CONFIGURATION");
        if (config instanceof IDPType) {
            IDPType idpType = (IDPType)config;
            String attribStr = idpType.getAttributeManager();
            this.insantiateAttributeManager(attribStr);
        }
    }

    public void initHandlerConfig(SAML2HandlerConfig handlerConfig) throws ConfigurationException {
        super.initHandlerConfig(handlerConfig);
        String attribStr = (String)this.handlerConfig.getParameter("ATTRIBUTE_MANAGER");
        this.insantiateAttributeManager(attribStr);
        List ak = (List)this.handlerConfig.getParameter("ATTRIBUTE_KEYS");
        if (ak != null) {
            this.attributeKeys.addAll(ak);
        }
    }

    public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (request.getSAML2Object() instanceof LogoutRequestType) {
            return;
        }
        if (this.getType() == SAML2Handler.HANDLER_TYPE.SP) {
            return;
        }
        HTTPContext httpContext = (HTTPContext)request.getContext();
        HttpSession session = httpContext.getRequest().getSession(false);
        Principal userPrincipal = (Principal)session.getAttribute("jboss_identity.principal");
        Map attribs = (Map)session.getAttribute("ATTRIBUTES");
        if (attribs == null) {
            attribs = this.attribManager.getAttributes(userPrincipal, this.attributeKeys);
            session.setAttribute("ATTRIBUTES", (Object)attribs);
        }
    }

    private void insantiateAttributeManager(String attribStr) throws ConfigurationException {
        if (attribStr != null && !"".equals(attribStr)) {
            ClassLoader tcl = SecurityActions.getContextClassLoader();
            try {
                this.attribManager = (AttributeManager)tcl.loadClass(attribStr).newInstance();
                if (this.trace) {
                    log.trace((Object)("AttributeManager set to " + this.attribManager));
                }
            }
            catch (Exception e) {
                log.error((Object)"Exception initializing attribute manager:", (Throwable)e);
                throw new ConfigurationException();
            }
        }
    }
}

