/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.web.handlers.saml2;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.api.saml.v2.request.SAML2Request;
import org.jboss.identity.federation.api.saml.v2.response.SAML2Response;
import org.jboss.identity.federation.core.exceptions.ConfigurationException;
import org.jboss.identity.federation.core.exceptions.ProcessingException;
import org.jboss.identity.federation.core.saml.v2.common.IDGenerator;
import org.jboss.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.jboss.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.jboss.identity.federation.saml.v2.SAML2Object;
import org.jboss.identity.federation.saml.v2.protocol.LogoutRequestType;
import org.jboss.identity.federation.saml.v2.protocol.ObjectFactory;
import org.jboss.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.jboss.identity.federation.saml.v2.protocol.ResponseType;
import org.jboss.identity.federation.saml.v2.protocol.StatusCodeType;
import org.jboss.identity.federation.saml.v2.protocol.StatusResponseType;
import org.jboss.identity.federation.saml.v2.protocol.StatusType;
import org.jboss.identity.federation.web.core.HTTPContext;
import org.jboss.identity.federation.web.core.IdentityServer;
import org.jboss.identity.federation.web.handlers.saml2.BaseSAML2Handler;
import org.xml.sax.SAXException;

public class SAML2LogOutHandler
extends BaseSAML2Handler {
    private static Logger log = Logger.getLogger(SAML2LogOutHandler.class);
    private boolean trace = log.isTraceEnabled();
    private IDPLogOutHandler idp = new IDPLogOutHandler();
    private SPLogOutHandler sp = new SPLogOutHandler();
    private ObjectFactory objectFactory = new ObjectFactory();

    public void generateSAMLRequest(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (request.getTypeOfRequestToBeGenerated() == null) {
            if (this.trace) {
                log.trace((Object)"Request type to be generated=null");
            }
            return;
        }
        if (SAML2HandlerRequest.GENERATE_REQUEST_TYPE.LOGOUT != request.getTypeOfRequestToBeGenerated()) {
            return;
        }
        if (this.getType() == SAML2Handler.HANDLER_TYPE.IDP) {
            this.idp.generateSAMLRequest(request, response);
        } else {
            this.sp.generateSAMLRequest(request, response);
        }
    }

    public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (!(request.getSAML2Object() instanceof LogoutRequestType)) {
            return;
        }
        if (this.getType() == SAML2Handler.HANDLER_TYPE.IDP) {
            this.idp.handleRequestType(request, response);
        } else {
            this.sp.handleRequestType(request, response);
        }
    }

    public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (request.getSAML2Object() instanceof ResponseType) {
            return;
        }
        if (!(request.getSAML2Object() instanceof StatusResponseType)) {
            return;
        }
        if (this.getType() == SAML2Handler.HANDLER_TYPE.IDP) {
            this.idp.handleStatusResponseType(request, response);
        } else {
            this.sp.handleStatusResponseType(request, response);
        }
    }

    private class SPLogOutHandler {
        private SPLogOutHandler() {
        }

        public void generateSAMLRequest(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
            SAML2Request samlRequest = new SAML2Request();
            try {
                LogoutRequestType lot = samlRequest.createLogoutRequest(request.getIssuer().getValue());
                response.setResultingDocument(samlRequest.convert((RequestAbstractType)lot));
                response.setSendRequest(true);
            }
            catch (Exception e) {
                throw new ProcessingException((Throwable)e);
            }
        }

        public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
            StatusResponseType statusResponseType = (StatusResponseType)request.getSAML2Object();
            HTTPContext httpContext = (HTTPContext)request.getContext();
            HttpServletRequest servletRequest = httpContext.getRequest();
            HttpSession session = servletRequest.getSession(false);
            StatusType statusType = statusResponseType.getStatus();
            StatusCodeType statusCode = statusType.getStatusCode();
            StatusCodeType secondLevelstatusCode = statusCode.getStatusCode();
            if (secondLevelstatusCode.getValue().equals(JBossSAMLURIConstants.STATUS_SUCCESS.get())) {
                session.invalidate();
            }
        }

        public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
            SAML2Object samlObject = request.getSAML2Object();
            if (!(samlObject instanceof LogoutRequestType)) {
                return;
            }
            LogoutRequestType logOutRequest = (LogoutRequestType)samlObject;
            HTTPContext httpContext = (HTTPContext)request.getContext();
            HttpServletRequest servletRequest = httpContext.getRequest();
            HttpSession session = servletRequest.getSession(false);
            String relayState = servletRequest.getParameter("RelayState");
            session.invalidate();
            StatusResponseType statusResponse = SAML2LogOutHandler.this.objectFactory.createStatusResponseType();
            StatusType statusType = SAML2LogOutHandler.this.objectFactory.createStatusType();
            StatusCodeType statusCodeType = SAML2LogOutHandler.this.objectFactory.createStatusCodeType();
            statusCodeType.setValue(JBossSAMLURIConstants.STATUS_RESPONDER.get());
            StatusCodeType status2ndLevel = SAML2LogOutHandler.this.objectFactory.createStatusCodeType();
            status2ndLevel.setValue(JBossSAMLURIConstants.STATUS_SUCCESS.get());
            statusCodeType.setStatusCode(status2ndLevel);
            statusType.setStatusCode(statusCodeType);
            statusResponse.setStatus(statusType);
            try {
                statusResponse.setIssueInstant(XMLTimeUtil.getIssueInstant());
            }
            catch (ConfigurationException e) {
                throw new ProcessingException((Throwable)e);
            }
            statusResponse.setInResponseTo(logOutRequest.getID());
            statusResponse.setID(IDGenerator.create((String)"ID_"));
            statusResponse.setIssuer(request.getIssuer());
            SAML2Response saml2Response = new SAML2Response();
            try {
                response.setResultingDocument(saml2Response.convert(statusResponse));
            }
            catch (Exception je) {
                throw new ProcessingException((Throwable)je);
            }
            response.setRelayState(relayState);
            response.setDestination(logOutRequest.getIssuer().getValue());
            response.setSendRequest(false);
        }
    }

    private class IDPLogOutHandler {
        private IDPLogOutHandler() {
        }

        public void generateSAMLRequest(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        }

        public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
            SAML2Object samlObject = request.getSAML2Object();
            StatusResponseType statusResponseType = (StatusResponseType)samlObject;
            HTTPContext httpContext = (HTTPContext)request.getContext();
            HttpServletRequest httpRequest = httpContext.getRequest();
            HttpSession httpSession = httpRequest.getSession(false);
            String relayState = request.getRelayState();
            ServletContext servletCtx = httpContext.getServletContext();
            IdentityServer server = (IdentityServer)servletCtx.getAttribute("IDENTITY_SERVER");
            if (server == null) {
                throw new ProcessingException("Identity Server not found");
            }
            String sessionID = httpSession.getId();
            String statusIssuer = statusResponseType.getIssuer().getValue();
            server.stack().deRegisterTransitParticipant(sessionID, statusIssuer);
            String nextParticipant = this.getParticipant(server, sessionID, relayState);
            if (nextParticipant == null || nextParticipant.equals(relayState)) {
                try {
                    this.generateSuccessStatusResponseType(statusResponseType.getInResponseTo(), request, response, relayState);
                }
                catch (Exception e) {
                    throw new ProcessingException((Throwable)e);
                }
                httpSession.invalidate();
            } else {
                server.stack().registerTransitParticipant(sessionID, nextParticipant);
                response.setRelayState(relayState);
                response.setDestination(nextParticipant);
                SAML2Request saml2Request = new SAML2Request();
                try {
                    LogoutRequestType lort = saml2Request.createLogoutRequest(request.getIssuer().getValue());
                    response.setResultingDocument(saml2Request.convert((RequestAbstractType)lort));
                    response.setSendRequest(true);
                }
                catch (Exception e) {
                    throw new ProcessingException((Throwable)e);
                }
            }
        }

        public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
            HTTPContext httpContext = (HTTPContext)request.getContext();
            HttpSession session = httpContext.getRequest().getSession(false);
            String sessionID = session.getId();
            String relayState = httpContext.getRequest().getParameter("RelayState");
            LogoutRequestType logOutRequest = (LogoutRequestType)request.getSAML2Object();
            String issuer = logOutRequest.getIssuer().getValue();
            try {
                SAML2Request saml2Request = new SAML2Request();
                ServletContext servletCtx = httpContext.getServletContext();
                IdentityServer server = (IdentityServer)servletCtx.getAttribute("IDENTITY_SERVER");
                if (server == null) {
                    throw new ProcessingException("Identity Server not found");
                }
                String originalIssuer = relayState == null ? issuer : relayState;
                String participant = this.getParticipant(server, sessionID, originalIssuer);
                if (participant == null || participant.equals(originalIssuer)) {
                    session.invalidate();
                    server.stack().pop(sessionID);
                    this.generateSuccessStatusResponseType(logOutRequest.getID(), request, response, originalIssuer);
                    response.setSendRequest(false);
                } else {
                    server.stack().registerTransitParticipant(sessionID, participant);
                    if (relayState == null) {
                        relayState = originalIssuer;
                    }
                    response.setRelayState(originalIssuer);
                    response.setDestination(participant);
                    LogoutRequestType lort = saml2Request.createLogoutRequest(request.getIssuer().getValue());
                    long assertionValidity = (Long)request.getOptions().get("ASSERTIONS_VALIDITY");
                    lort.setNotOnOrAfter(XMLTimeUtil.add((XMLGregorianCalendar)lort.getIssueInstant(), (long)assertionValidity));
                    lort.setDestination(participant);
                    response.setResultingDocument(saml2Request.convert((RequestAbstractType)lort));
                    response.setSendRequest(true);
                }
            }
            catch (ParserConfigurationException pe) {
                throw new ProcessingException((Throwable)pe);
            }
            catch (ConfigurationException pe) {
                throw new ProcessingException((Throwable)pe);
            }
            catch (JAXBException pe) {
                throw new ProcessingException((Throwable)pe);
            }
            catch (IOException pe) {
                throw new ProcessingException((Throwable)pe);
            }
            catch (SAXException pe) {
                throw new ProcessingException((Throwable)pe);
            }
        }

        private void generateSuccessStatusResponseType(String logOutRequestID, SAML2HandlerRequest request, SAML2HandlerResponse response, String originalIssuer) throws ConfigurationException, ParserConfigurationException, ProcessingException {
            StatusResponseType statusResponse = SAML2LogOutHandler.this.objectFactory.createStatusResponseType();
            StatusType statusType = SAML2LogOutHandler.this.objectFactory.createStatusType();
            StatusCodeType statusCodeType = SAML2LogOutHandler.this.objectFactory.createStatusCodeType();
            statusCodeType.setValue(JBossSAMLURIConstants.STATUS_RESPONDER.get());
            StatusCodeType status2ndLevel = SAML2LogOutHandler.this.objectFactory.createStatusCodeType();
            status2ndLevel.setValue(JBossSAMLURIConstants.STATUS_SUCCESS.get());
            statusCodeType.setStatusCode(status2ndLevel);
            statusType.setStatusCode(statusCodeType);
            statusResponse.setStatus(statusType);
            statusResponse.setIssueInstant(XMLTimeUtil.getIssueInstant());
            statusResponse.setInResponseTo(logOutRequestID);
            statusResponse.setID(IDGenerator.create((String)"ID_"));
            statusResponse.setIssuer(request.getIssuer());
            try {
                SAML2Response saml2Response = new SAML2Response();
                response.setResultingDocument(saml2Response.convert(statusResponse));
            }
            catch (JAXBException je) {
                throw new ProcessingException((Throwable)je);
            }
            response.setDestination(originalIssuer);
        }

        private String getParticipant(IdentityServer server, String sessionID, String originalRequestor) {
            int participants = server.stack().getParticipants(sessionID);
            String participant = originalRequestor;
            if (participants > 0) {
                do {
                    participant = server.stack().pop(sessionID);
                } while (--participants > 0 && participant.equals(originalRequestor));
            }
            return participant;
        }
    }
}

