/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.web.handlers.saml2;

import java.security.Key;
import java.security.KeyPair;
import java.security.PublicKey;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.api.saml.v2.sig.SAML2Signature;
import org.jboss.identity.federation.core.exceptions.ProcessingException;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.jboss.identity.federation.core.util.XMLSignatureUtil;
import org.jboss.identity.federation.web.handlers.saml2.BaseSAML2Handler;
import org.w3c.dom.Document;

public class SAML2SignatureHandler
extends BaseSAML2Handler {
    private static Logger log = Logger.getLogger(SAML2SignatureHandler.class);
    private boolean trace = log.isTraceEnabled();

    public void generateSAMLRequest(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        Document samlDocument = response.getResultingDocument();
        if (samlDocument == null && this.trace) {
            log.trace((Object)"No document generated in the handler chain. Cannot generate signature");
            return;
        }
        KeyPair keypair = (KeyPair)this.handlerChainConfig.getParameter("KEYPAIR");
        if (keypair == null) {
            log.error((Object)"Key Pair cannot be found");
            throw new ProcessingException("KeyPair not found");
        }
        SAML2Signature samlSignature = new SAML2Signature();
        String id = samlDocument.getDocumentElement().getAttribute("ID");
        try {
            samlSignature.sign(samlDocument, id, keypair);
        }
        catch (Exception e) {
            log.error((Object)"Unable to sign:", (Throwable)e);
            throw new ProcessingException("Unable to sign");
        }
    }

    public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        Document signedDocument = request.getRequestDocument();
        PublicKey publicKey = (PublicKey)request.getOptions().get("SENDER_PUBLIC_KEY");
        this.validateSender(signedDocument, publicKey);
    }

    public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        Document signedDocument = request.getRequestDocument();
        PublicKey publicKey = (PublicKey)request.getOptions().get("SENDER_PUBLIC_KEY");
        this.validateSender(signedDocument, publicKey);
    }

    private void validateSender(Document signedDocument, PublicKey publicKey) throws ProcessingException {
        try {
            XMLSignatureUtil.validate((Document)signedDocument, (Key)publicKey);
        }
        catch (Exception e) {
            log.error((Object)"Error validating signature:", (Throwable)e);
            throw new ProcessingException("Error validating signature.");
        }
    }
}

