/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection.injector;

import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.injection.injector.metadata.EnvironmentEntryType;
import org.jboss.injection.injector.metadata.InjectionTargetType;
import org.jboss.injection.injector.metadata.JndiEnvironmentRefsGroup;
import org.jboss.injection.injector.util.InjectionPoint;
import org.jboss.injection.injector.util.InjectionPointFactory;
import org.jboss.injection.injector.util.NoSuchPropertyException;
import org.jboss.injection.manager.spi.InjectionContext;
import org.jboss.injection.manager.spi.InjectionException;
import org.jboss.injection.manager.spi.Injector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EEInjector
implements Injector {
    private Context context;
    private JndiEnvironmentRefsGroup environment;

    public EEInjector(Context context, JndiEnvironmentRefsGroup environment) {
        this.context = context;
        this.environment = environment;
    }

    protected Context getContext() {
        return this.context;
    }

    protected JndiEnvironmentRefsGroup getEnvironment() {
        return this.environment;
    }

    public <T> void inject(InjectionContext<T> injectionContext) {
        try {
            this.inject(injectionContext.getInjectedType(), injectionContext.getInjectionTarget());
            injectionContext.proceed();
        }
        catch (NamingException e) {
            throw new InjectionException((Throwable)e);
        }
    }

    public void inject(Object instance) throws NamingException {
        this.inject(instance.getClass(), instance);
    }

    private void inject(Class<?> cls, Object instance) throws NamingException {
        try {
            for (EnvironmentEntryType entry : this.environment.getEntries()) {
                String name = entry.getName();
                for (InjectionTargetType target : entry.getInjectionTargets()) {
                    if (!target.getInjectionTargetClass().isAssignableFrom(cls)) continue;
                    Object value = this.getContext().lookup(name);
                    this.inject(value, target.getInjectionTargetClass(), instance, target.getInjectionTargetName());
                }
            }
        }
        catch (NoSuchPropertyException e) {
            throw new RuntimeException(e);
        }
    }

    private void inject(Object value, Class<?> cls, Object instance, String name) throws NoSuchPropertyException {
        InjectionPoint p = InjectionPointFactory.create(cls, name);
        p.set(instance, value);
    }
}

