/*
 * JBoss, Home of Professional Open Source
 * Copyright 2007, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.profileservice.spi.repository;

import java.util.Collection;

/**
 * A mutable extension of the OBR Repository
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision: 65458 $
 */
public interface MutableRepository extends Repository
{
   /** */
   public enum ModifyStatus {ADDED, MODIFIED, REMOVED};

   /**
    * Add a resource to the repository.
    * @param resource the resource to add
    * @throws Exception thrown on any addition failure
    */
   public void addResource(Resource resource)
      throws Exception;
   /**
    * Remove a resource from the repository
    * @param name the resource SYMBOLIC_NAME or ID
    * @return the Resource that was removed if found, null otherwise.
    * @throws Exception thrown on any remove failure
    */
   public Resource removeResource(String name)
      throws Exception;
   /**
    * Return a collection of resources that have been modified since
    * the last call to this method. The returned resources contain
    * a modifyStatus property of type ModifyStatus to indicate the
    * type of change.
    * 
    * @return The Resources that have been modified.
    * @throws Exception
    */
   public Collection<Resource> getModifiedResources()
      throws Exception;
}
