/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */ 
package org.jboss.profileservice.spi;

import java.util.Collection;

/**
 * A mutable profile.
 * 
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision$
 */
public interface MutableProfile extends Profile
{
   
   /**
    * Add a deployment.
    * 
    * @param deployment the deployment
    * @throws Exception for any error
    */
   void addDeployment(ProfileDeployment deployment) throws Exception;

   /**
    * Remove a deployment.
    * 
    * @param name the deployment name
    * @return the DeploymentContext for the name if found
    * @throws NoSuchDeploymentException if the deployment was not found
    * @throws Exception for any error
    */
   ProfileDeployment removeDeployment(String name) throws NoSuchDeploymentException, Exception;
   
   /**
    * Get the deployments that have been modified since the last
    * check. 
    * 
    * @return the modified deployments, empty if none exist
    * @throws Exception - thrown on error scanning for deployments
    */
   Collection<ModificationInfo> getModifiedDeployments() throws Exception;
   
   /**
    * Enable/disable the getModifiedDeployments results. This can be
    * used to disable the getModifiedDeployments results during
    * periods such as bootstrap where changes should be delayed.
    * 
    * @see #getModifiedDeployments
    * @param flag - the enable/disable flag
    */
   void enableModifiedDeploymentChecks(boolean flag);

}
