/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.tomcat.jta.integration;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.narayana.tomcat.jta.integration.AbstractCase;
import org.jboss.narayana.tomcat.jta.integration.app.TestApplication;
import org.jboss.narayana.tomcat.jta.integration.app.TestExecutor;
import org.jboss.narayana.tomcat.jta.integration.app.TestXAResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunAsClient
@RunWith(value=Arquillian.class)
public class BaseITCase
extends AbstractCase {
    private static final Logger LOGGER = Logger.getLogger(BaseITCase.class.getName());
    private static final String DEPLOYMENT_NAME = "test";
    private static final String EXECUTOR_URL = "http://localhost:8080/test/executor/";
    private static final String NARAYANA_DEPENDENCY = "org.jboss.integration:narayana-tomcat:" + System.getProperty("project.version");
    private static final String RESTEASY_DEPENDENCY = "org.jboss.resteasy:resteasy-servlet-initializer:" + System.getProperty("version.org.jboss.resteasy");
    private Client client;
    @ArquillianResource
    private Deployer deployer;
    @ArquillianResource
    private ContainerController controller;

    @Deployment(name="Basic-app", managed=false)
    public static WebArchive getDeployment() {
        File[] libraries = ((MavenFormatStage)((MavenStrategyStage)Maven.resolver().resolve(new String[]{NARAYANA_DEPENDENCY, RESTEASY_DEPENDENCY})).withTransitivity()).asFile();
        WebArchive archive = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"test.war")).addClasses(new Class[]{TestApplication.class, TestExecutor.class, TestXAResource.class})).addAsLibraries(libraries)).addAsResource("jbossts-properties.xml", "jbossts-properties.xml")).addAsWebInfResource("web.xml", "web.xml")).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        LOGGER.info(archive.toString(true));
        webArchive = archive;
        return archive;
    }

    @Before
    public void before() {
        try {
            FileUtils.deleteDirectory((File)Paths.get(catalinaHome, "work", "Catalina", "localhost", DEPLOYMENT_NAME, "ObjectStore").toFile());
            FileUtils.deleteDirectory((File)Paths.get(catalinaHome, "work", "Narayana", "ObjectStore").toFile());
            FileUtils.deleteDirectory((File)Paths.get(catalinaHome, "bin", "ObjectStore").toFile());
            FileUtils.deleteDirectory((File)Paths.get(catalinaHome, "webapps", DEPLOYMENT_NAME).toFile());
            FileUtils.deleteQuietly((File)Paths.get(catalinaHome, "webapps", "test.war").toFile());
        }
        catch (IOException | NullPointerException e) {
            LOGGER.log(Level.SEVERE, "Failed to delete stray ObjectStore(s).", e);
        }
        this.controller.start("tomcat");
        this.client = ClientBuilder.newClient();
        this.deployer.deploy("Basic-app");
    }

    @After
    public void after() {
        this.client.close();
        this.deployer.undeploy("Basic-app");
        this.controller.stop("tomcat");
        Assert.assertTrue((String)"Failed to clean DB, check logs for the root cause.", (boolean)dba.cleanDB(db));
        BaseITCase.executeTestStatement(dbDriverAbsolutePath, db, dba);
    }

    @Test
    public void testJndi() {
        this.test("http://localhost:8080/test/executor/jndi");
    }

    @Test
    public void testRecovery() {
        IntStream.range(0, 10).forEach(i -> this.test("http://localhost:8080/test/executor/recovery"));
    }

    private void test(String url) {
        Response response = this.client.target(url).request().get();
        if (response.getStatus() == 500) {
            Assert.fail((String)((String)response.readEntity(String.class)));
        } else if (response.getStatus() != 204) {
            Assert.fail((String)String.format("Unexpected test status: %d", response.getStatus()));
        }
    }
}

