/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.tomcat.jta.integration;

import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionManagerImple;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.apache.naming.NamingContext;
import org.apache.tomcat.dbcp.dbcp2.managed.BasicManagedDataSource;
import org.h2.jdbcx.JdbcDataSource;
import org.jboss.narayana.tomcat.jta.NarayanaJtaServletContextListener;
import org.jboss.narayana.tomcat.jta.TransactionalDataSourceFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestTransactionalDataSourceFactory {
    private NarayanaJtaServletContextListener listener = new NarayanaJtaServletContextListener();

    @Before
    public void setUp() {
        this.listener.contextInitialized(null);
    }

    @After
    public void tearDown() {
        this.listener.contextDestroyed(null);
    }

    @Test
    public void testProperties() throws Exception {
        Reference ref = new Reference("javax.sql.XADataSource", TransactionalDataSourceFactory.class.getName(), null);
        Properties properties = this.getTestProperties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            ref.add(new StringRefAddr((String)entry.getKey(), (String)entry.getValue()));
        }
        NamingContext context = new NamingContext(null, "test");
        TransactionManagerImple tm = new TransactionManagerImple();
        JdbcDataSource h2 = new JdbcDataSource();
        h2.setURL("jdbc:h2:mem:test");
        h2.setUser("sa");
        h2.setPassword("sa");
        context.bind("transactionManager", (Object)tm);
        context.bind("myDataSource", (Object)h2);
        TransactionalDataSourceFactory factory = new TransactionalDataSourceFactory();
        BasicManagedDataSource ds = (BasicManagedDataSource)factory.getObjectInstance((Object)ref, null, (Context)context, null);
        Assert.assertNotNull((Object)ds);
        this.checkDataSourceProperties(ds);
        this.checkConnectionPoolProperties(ds);
    }

    private Properties getTestProperties() {
        Properties properties = new Properties();
        properties.setProperty("transactionManager", "transactionManager");
        properties.setProperty("xaDataSource", "myDataSource");
        properties.setProperty("maxTotal", "10");
        properties.setProperty("maxIdle", "8");
        properties.setProperty("minIdle", "0");
        properties.setProperty("maxWaitMillis", "500");
        properties.setProperty("initialSize", "5");
        properties.setProperty("defaultAutoCommit", "true");
        properties.setProperty("defaultReadOnly", "false");
        properties.setProperty("defaultTransactionIsolation", "READ_COMMITTED");
        properties.setProperty("defaultCatalog", "test");
        properties.setProperty("testOnBorrow", "true");
        properties.setProperty("testOnReturn", "false");
        properties.setProperty("username", "username");
        properties.setProperty("password", "password");
        properties.setProperty("validationQuery", "SELECT 1");
        properties.setProperty("validationQueryTimeout", "100");
        properties.setProperty("connectionInitSqls", "SELECT 1;SELECT 2");
        properties.setProperty("timeBetweenEvictionRunsMillis", "1000");
        properties.setProperty("minEvictableIdleTimeMillis", "2000");
        properties.setProperty("softMinEvictableIdleTimeMillis", "3000");
        properties.setProperty("numTestsPerEvictionRun", "2");
        properties.setProperty("testWhileIdle", "true");
        properties.setProperty("accessToUnderlyingConnectionAllowed", "true");
        properties.setProperty("removeAbandonedOnBorrow", "true");
        properties.setProperty("removeAbandonedOnMaintenance", "true");
        properties.setProperty("removeAbandonedTimeout", "3000");
        properties.setProperty("logAbandoned", "true");
        properties.setProperty("abandonedUsageTracking", "true");
        properties.setProperty("poolPreparedStatements", "true");
        properties.setProperty("maxOpenPreparedStatements", "10");
        properties.setProperty("lifo", "true");
        properties.setProperty("fastFailValidation", "true");
        properties.setProperty("disconnectionSqlCodes", "XXX,YYY");
        properties.setProperty("jmxName", "org.apache.commons.dbcp2:name=test");
        return properties;
    }

    private void checkDataSourceProperties(BasicManagedDataSource ds) throws Exception {
        Assert.assertEquals((long)10L, (long)ds.getMaxTotal());
        Assert.assertEquals((long)8L, (long)ds.getMaxIdle());
        Assert.assertEquals((long)0L, (long)ds.getMinIdle());
        Assert.assertEquals((long)500L, (long)ds.getMaxWaitMillis());
        Assert.assertEquals((long)5L, (long)ds.getInitialSize());
        Assert.assertEquals((long)5L, (long)ds.getNumIdle());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ds.getDefaultAutoCommit());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getDefaultReadOnly());
        Assert.assertEquals((long)2L, (long)ds.getDefaultTransactionIsolation());
        Assert.assertEquals((Object)"test", (Object)ds.getDefaultCatalog());
        Assert.assertTrue((boolean)ds.getTestOnBorrow());
        Assert.assertFalse((boolean)ds.getTestOnReturn());
        Assert.assertEquals((Object)"username", (Object)ds.getUsername());
        Assert.assertEquals((Object)"password", (Object)ds.getPassword());
        Assert.assertEquals((Object)"SELECT 1", (Object)ds.getValidationQuery());
        Assert.assertEquals((long)100L, (long)ds.getValidationQueryTimeout());
        Assert.assertEquals((long)2L, (long)ds.getConnectionInitSqls().size());
        Assert.assertEquals((Object)"SELECT 1", ds.getConnectionInitSqls().get(0));
        Assert.assertEquals((Object)"SELECT 2", ds.getConnectionInitSqls().get(1));
        Assert.assertEquals((long)1000L, (long)ds.getTimeBetweenEvictionRunsMillis());
        Assert.assertEquals((long)2000L, (long)ds.getMinEvictableIdleTimeMillis());
        Assert.assertEquals((long)3000L, (long)ds.getSoftMinEvictableIdleTimeMillis());
        Assert.assertEquals((long)2L, (long)ds.getNumTestsPerEvictionRun());
        Assert.assertTrue((boolean)ds.getTestWhileIdle());
        Assert.assertTrue((boolean)ds.isAccessToUnderlyingConnectionAllowed());
        Assert.assertTrue((boolean)ds.getRemoveAbandonedOnBorrow());
        Assert.assertTrue((boolean)ds.getRemoveAbandonedOnMaintenance());
        Assert.assertEquals((long)3000L, (long)ds.getRemoveAbandonedTimeout());
        Assert.assertTrue((boolean)ds.getLogAbandoned());
        Assert.assertTrue((boolean)ds.getAbandonedUsageTracking());
        Assert.assertTrue((boolean)ds.isPoolPreparedStatements());
        Assert.assertEquals((long)10L, (long)ds.getMaxOpenPreparedStatements());
        Assert.assertTrue((boolean)ds.getLifo());
        Assert.assertTrue((boolean)ds.getFastFailValidation());
        Assert.assertTrue((boolean)ds.getDisconnectionSqlCodes().contains("XXX"));
        Assert.assertTrue((boolean)ds.getDisconnectionSqlCodes().contains("YYY"));
        Assert.assertEquals((Object)"org.apache.commons.dbcp2:name=test", (Object)ds.getJmxName());
    }

    private void checkConnectionPoolProperties(BasicManagedDataSource ds) {
        Assert.assertEquals((long)10L, (long)ds.getMaxTotal());
        Assert.assertEquals((long)8L, (long)ds.getMaxIdle());
        Assert.assertEquals((long)0L, (long)ds.getMinIdle());
        Assert.assertEquals((long)500L, (long)ds.getMaxWaitMillis());
        Assert.assertEquals((long)5L, (long)ds.getNumIdle());
        Assert.assertEquals((long)5L, (long)ds.getInitialSize());
        Assert.assertTrue((boolean)ds.getTestOnBorrow());
        Assert.assertFalse((boolean)ds.getTestOnReturn());
        Assert.assertEquals((long)1000L, (long)ds.getTimeBetweenEvictionRunsMillis());
        Assert.assertEquals((long)2000L, (long)ds.getMinEvictableIdleTimeMillis());
        Assert.assertEquals((long)3000L, (long)ds.getSoftMinEvictableIdleTimeMillis());
        Assert.assertEquals((long)2L, (long)ds.getNumTestsPerEvictionRun());
        Assert.assertTrue((boolean)ds.getTestWhileIdle());
        Assert.assertTrue((boolean)ds.getRemoveAbandonedOnBorrow());
        Assert.assertTrue((boolean)ds.getRemoveAbandonedOnMaintenance());
        Assert.assertEquals((long)3000L, (long)ds.getRemoveAbandonedTimeout());
        Assert.assertTrue((boolean)ds.getLogAbandoned());
        Assert.assertTrue((boolean)ds.getLifo());
    }
}

