/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.tomcat.jta.integration.app;

import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryModule;
import com.arjuna.ats.jta.recovery.XAResourceRecoveryHelper;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAResource;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.apache.tomcat.dbcp.dbcp2.DelegatingConnection;
import org.jboss.narayana.tomcat.jta.integration.app.TestXAResource;

@Path(value="executor")
public class TestExecutor {
    public static final String BASE_PATH = "executor";
    public static final String JNDI_TEST = "jndi";
    public static final String RECOVERY_TEST = "recovery";
    private static final Logger LOGGER = Logger.getLogger(TestExecutor.class.getSimpleName());

    @GET
    @Path(value="jndi")
    public Response verifyJndi() throws NamingException {
        LOGGER.info("Verifying JNDI");
        if (this.getUserTransaction() == null) {
            return Response.serverError().entity((Object)"UserTransaction not found in JNDI").build();
        }
        if (this.getTransactionManager() == null) {
            return Response.serverError().entity((Object)"TransactionManager not found in JNDI").build();
        }
        if (this.getTransactionSynchronizationRegistry() == null) {
            return Response.serverError().entity((Object)"TransactionSynchronizationRegistry not found in JNDI").build();
        }
        if (this.getTransactionalDataSource() == null) {
            return Response.serverError().entity((Object)"DataSource not found in JNDI").build();
        }
        return Response.noContent().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="recovery")
    public Response verifyRecovery() throws NamingException, HeuristicRollbackException, RollbackException, HeuristicMixedException, SystemException, NotSupportedException, SQLException {
        LOGGER.info("Verifying recovery");
        TestXAResource.reset();
        this.createTestTable();
        String testEntry = "test-entry-" + LocalTime.now();
        TestXAResource testXAResource = new TestXAResource();
        Connection connection = null;
        this.updateXARecoveryModule(m -> m.addXAResourceRecoveryHelper((XAResourceRecoveryHelper)testXAResource));
        try {
            this.getTransactionManager().begin();
            this.getTransactionManager().getTransaction().enlistResource((XAResource)testXAResource);
            connection = this.getTransactionalDataSource().getConnection();
            this.writeToTheDatabase(connection, testEntry);
            try {
                this.getTransactionManager().commit();
                Response response = Response.serverError().entity((Object)"Commit failure was expected").build();
                return response;
            }
            catch (Throwable ignored) {
                Response response;
                block19: {
                    RecoveryManager.manager().scan();
                    RecoveryManager.manager().scan();
                    response = this.getRecoveryTestResponse(connection, testEntry);
                    if (connection == null) break block19;
                    connection.close();
                    try {
                        Field _connField = DelegatingConnection.class.getDeclaredField("connection");
                        _connField.setAccessible(true);
                        Object o = _connField.get(connection);
                        o = _connField.get(o);
                        Field currentTransactionField = o.getClass().getEnclosingClass().getDeclaredField("currentTransaction");
                        currentTransactionField.setAccessible(true);
                        Field enclosing = o.getClass().getDeclaredField("this$0");
                        enclosing.setAccessible(true);
                        o = enclosing.get(o);
                        currentTransactionField.set(o, null);
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                this.updateXARecoveryModule(m -> m.removeXAResourceRecoveryHelper((XAResourceRecoveryHelper)testXAResource));
                return response;
            }
        }
        finally {
            if (connection != null) {
                connection.close();
                try {
                    Field _connField = DelegatingConnection.class.getDeclaredField("connection");
                    _connField.setAccessible(true);
                    Object o = _connField.get(connection);
                    o = _connField.get(o);
                    Field currentTransactionField = o.getClass().getEnclosingClass().getDeclaredField("currentTransaction");
                    currentTransactionField.setAccessible(true);
                    Field enclosing = o.getClass().getDeclaredField("this$0");
                    enclosing.setAccessible(true);
                    o = enclosing.get(o);
                    currentTransactionField.set(o, null);
                }
                catch (NullPointerException _connField) {
                }
                catch (NoSuchFieldException _connField) {
                }
                catch (IllegalAccessException _connField) {}
            }
            this.updateXARecoveryModule(m -> m.removeXAResourceRecoveryHelper((XAResourceRecoveryHelper)testXAResource));
        }
    }

    private void updateXARecoveryModule(Consumer<XARecoveryModule> action) {
        RecoveryManager.manager().getModules().stream().filter(m -> m instanceof XARecoveryModule).forEach(m -> action.accept((XARecoveryModule)m));
    }

    private Response getRecoveryTestResponse(Connection connection, String testEntry) throws SQLException, NamingException {
        if (this.didRecoveryHappen(connection, testEntry)) {
            return Response.noContent().build();
        }
        return Response.serverError().entity((Object)"Recovery failed").build();
    }

    private boolean didRecoveryHappen(Connection connection, String entry) throws SQLException, NamingException {
        List<String> expectedMethods = Arrays.asList("start", "end", "prepare", "commit");
        List<String> actualMethods = TestXAResource.getMethodCalls();
        LOGGER.info("Verifying TestXAResource methods. Expected=" + expectedMethods + ", actual=" + actualMethods);
        boolean entryExists = this.doesEntryExist(connection, entry);
        LOGGER.info("Verifying if database entry exists:" + entryExists);
        return expectedMethods.equals(actualMethods) && entryExists;
    }

    private boolean doesEntryExist(Connection connection, String entry) throws SQLException, NamingException {
        String query = "SELECT COUNT(*) FROM test WHERE value='" + entry + "'";
        try {
            Statement statement = connection.createStatement();
            ResultSet result = statement.executeQuery(query);
            return result.next() && result.getInt(1) > 0;
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, e, () -> String.format("Cannot get result when querying entry '%s'", entry));
            return false;
        }
    }

    private void writeToTheDatabase(Connection connection, String entry) throws NamingException, SQLException {
        String query = "INSERT INTO test VALUES ('" + entry + "')";
        Statement statement = connection.createStatement();
        statement.execute(query);
    }

    private UserTransaction getUserTransaction() throws NamingException {
        return (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
    }

    private TransactionManager getTransactionManager() throws NamingException {
        return (TransactionManager)InitialContext.doLookup("java:comp/env/TransactionManager");
    }

    private TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() throws NamingException {
        return (TransactionSynchronizationRegistry)InitialContext.doLookup("java:comp/env/TransactionSynchronizationRegistry");
    }

    private DataSource getTransactionalDataSource() throws NamingException {
        return (DataSource)InitialContext.doLookup("java:comp/env/transactionalDataSource");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTestTable() throws SQLException, NamingException {
        String query = "CREATE TABLE IF NOT EXISTS test (value VARCHAR(100))";
        try (Connection connection = null;){
            connection = this.getTransactionalDataSource().getConnection();
            Statement statement = connection.createStatement();
            statement.execute(query);
        }
    }
}

