/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Index;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.PackedDataInputStream;
import org.jboss.jandex.Type;
import org.jboss.jandex.UnsupportedVersion;

public final class IndexReader {
    private static final int MAGIC = -1161945323;
    private static final byte VERSION = 1;
    private static final byte FIELD_TAG = 1;
    private static final byte METHOD_TAG = 2;
    private static final byte METHOD_PARAMATER_TAG = 3;
    private static final byte CLASS_TAG = 4;
    private InputStream input;
    private DotName[] classTable;
    private String[] stringTable;
    private HashMap<DotName, List<AnnotationTarget>> masterAnnotations;

    public IndexReader(InputStream input) {
        this.input = input;
    }

    public Index read() throws IOException {
        PackedDataInputStream stream = new PackedDataInputStream(new BufferedInputStream(this.input));
        if (stream.readInt() != -1161945323) {
            throw new IllegalArgumentException("Not a jandex index");
        }
        byte version = stream.readByte();
        if (version != 1) {
            throw new UnsupportedVersion("Version: " + version);
        }
        try {
            this.masterAnnotations = new HashMap();
            this.readClassTable(stream);
            this.readStringTable(stream);
            Index index = this.readClasses(stream);
            return index;
        }
        finally {
            this.classTable = null;
            this.stringTable = null;
            this.masterAnnotations = null;
        }
    }

    private Index readClasses(PackedDataInputStream stream) throws IOException {
        int entries = stream.readPackedU32();
        HashMap<DotName, List<ClassInfo>> subclasses = new HashMap<DotName, List<ClassInfo>>();
        HashMap<DotName, ClassInfo> classes = new HashMap<DotName, ClassInfo>();
        this.masterAnnotations = new HashMap();
        int i = 0;
        while (i < entries) {
            DotName name = this.classTable[stream.readPackedU32()];
            DotName superName = this.classTable[stream.readPackedU32()];
            short flags = stream.readShort();
            int numIntfs = stream.readPackedU32();
            DotName[] interfaces = new DotName[numIntfs];
            int j = 0;
            while (j < numIntfs) {
                interfaces[j] = this.classTable[stream.readPackedU32()];
                ++j;
            }
            HashMap<DotName, List<AnnotationTarget>> annotations = new HashMap<DotName, List<AnnotationTarget>>();
            ClassInfo clazz = new ClassInfo(name, superName, flags, interfaces, annotations);
            classes.put(name, clazz);
            this.addSubclass(subclasses, superName, clazz);
            this.readAnnotations(stream, annotations, clazz);
            ++i;
        }
        return new Index(this.masterAnnotations, subclasses, classes);
    }

    private void readAnnotations(PackedDataInputStream stream, Map<DotName, List<AnnotationTarget>> annotations, ClassInfo clazz) throws IOException {
        int numAnnotations = stream.readPackedU32();
        int j = 0;
        while (j < numAnnotations) {
            DotName annotation = this.classTable[stream.readPackedU32()];
            int numTargets = stream.readPackedU32();
            int k = 0;
            while (k < numTargets) {
                AnnotationTarget target;
                int tag = stream.readPackedU32();
                switch (tag) {
                    case 1: {
                        String name = this.stringTable[stream.readPackedU32()];
                        Type type = this.readType(stream);
                        short flags = stream.readShort();
                        target = new FieldInfo(clazz, name, type, flags);
                        break;
                    }
                    case 2: {
                        target = this.readMethod(clazz, stream);
                        break;
                    }
                    case 3: {
                        MethodInfo method = this.readMethod(clazz, stream);
                        target = new MethodParameterInfo(method, (short)stream.readPackedU32());
                        break;
                    }
                    case 4: {
                        target = clazz;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
                this.recordAnnotation(this.masterAnnotations, annotation, target);
                this.recordAnnotation(annotations, annotation, target);
                ++k;
            }
            ++j;
        }
    }

    private MethodInfo readMethod(ClassInfo clazz, PackedDataInputStream stream) throws IOException {
        String name = this.stringTable[stream.readPackedU32()];
        int numArgs = stream.readPackedU32();
        Type[] args = new Type[numArgs];
        int i = 0;
        while (i < numArgs) {
            args[i] = this.readType(stream);
            ++i;
        }
        Type returnType = this.readType(stream);
        short flags = stream.readShort();
        return new MethodInfo(clazz, name, args, returnType, flags);
    }

    private void recordAnnotation(Map<DotName, List<AnnotationTarget>> annotations, DotName annotation, AnnotationTarget target) {
        List<AnnotationTarget> list = annotations.get(annotation);
        if (list == null) {
            list = new ArrayList<AnnotationTarget>();
            annotations.put(annotation, list);
        }
        list.add(target);
    }

    private void addSubclass(HashMap<DotName, List<ClassInfo>> subclasses, DotName superName, ClassInfo currentClass) {
        List<ClassInfo> list = subclasses.get(superName);
        if (list == null) {
            list = new ArrayList<ClassInfo>();
            subclasses.put(superName, list);
        }
        list.add(currentClass);
    }

    private Type readType(PackedDataInputStream stream) throws IOException {
        Type.Kind kind = Type.Kind.fromOrdinal(stream.readByte());
        DotName name = this.classTable[stream.readPackedU32()];
        return new Type(name, kind);
    }

    private void readStringTable(PackedDataInputStream stream) throws IOException {
        int entries = stream.readPackedU32();
        this.stringTable = new String[entries];
        int i = 0;
        while (i < entries) {
            this.stringTable[i] = stream.readUTF();
            ++i;
        }
    }

    private void readClassTable(PackedDataInputStream stream) throws IOException {
        int entries = stream.readPackedU32();
        int lastDepth = -1;
        DotName curr = null;
        this.classTable = new DotName[++entries];
        int i = 1;
        while (i < entries) {
            int depth = stream.readPackedU32();
            String local = stream.readUTF();
            if (depth <= lastDepth) {
                while (lastDepth-- >= depth) {
                    curr = curr.prefix();
                }
            }
            this.classTable[i] = curr = new DotName(curr, local, true);
            lastDepth = depth;
            ++i;
        }
    }
}

