/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Index;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.StrongInternPool;
import org.jboss.jandex.Type;

public final class Indexer {
    private static final int CONSTANT_CLASS = 7;
    private static final int CONSTANT_FIELDREF = 9;
    private static final int CONSTANT_METHODREF = 10;
    private static final int CONSTANT_INTERFACEMETHODREF = 11;
    private static final int CONSTANT_STRING = 8;
    private static final int CONSTANT_INTEGER = 3;
    private static final int CONSTANT_FLOAT = 4;
    private static final int CONSTANT_LONG = 5;
    private static final int CONSTANT_DOUBLE = 6;
    private static final int CONSTANT_NAMEANDTYPE = 12;
    private static final int CONSTANT_UTF8 = 1;
    private static final byte[] RUNTIME_ANNOTATIONS = new byte[]{82, 117, 110, 116, 105, 109, 101, 86, 105, 115, 105, 98, 108, 101, 65, 110, 110, 111, 116, 97, 116, 105, 111, 110, 115};
    private static final byte[] RUNTIME_PARAM_ANNOTATIONS = new byte[]{82, 117, 110, 116, 105, 109, 101, 86, 105, 115, 105, 98, 108, 101, 80, 97, 114, 97, 109, 101, 116, 101, 114, 65, 110, 110, 111, 116, 97, 116, 105, 111, 110, 115};
    private static final int RUNTIME_ANNOTATIONS_LEN = RUNTIME_ANNOTATIONS.length;
    private static final int RUNTIME_PARAM_ANNOTATIONS_LEN = RUNTIME_PARAM_ANNOTATIONS.length;
    private static final int HAS_RUNTIME_ANNOTATION = 1;
    private static final int HAS_RUNTIME_PARAM_ANNOTATION = 2;
    private byte[] constantPool;
    private int[] constantPoolOffsets;
    private byte[] constantPoolAnnoAttrributes;
    private ClassInfo currentClass;
    private volatile ClassInfo publishClass;
    private HashMap<DotName, List<AnnotationTarget>> classAnnotations;
    private StrongInternPool<String> internPool;
    private Map<DotName, List<AnnotationTarget>> masterAnnotations;
    private Map<DotName, List<ClassInfo>> subclasses;
    private Map<DotName, ClassInfo> classes;
    private Map<String, DotName> names;

    private static boolean match(byte[] target, int offset, byte[] expected) {
        if (target.length - offset < expected.length) {
            return false;
        }
        int i = 0;
        while (i < expected.length) {
            if (target[offset + i] != expected[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static byte[] sizeToFit(byte[] buf, int needed, int offset, int remainingEntries) {
        if (offset + needed > buf.length) {
            buf = Arrays.copyOf(buf, buf.length + Math.max(needed, (remainingEntries + 1) * 20));
        }
        return buf;
    }

    private static void skipFully(InputStream s, long n) throws IOException {
        long total = 0L;
        while (total < n) {
            long skipped = s.skip(n - total);
            if (skipped < 0L) {
                throw new EOFException();
            }
            total += skipped;
        }
    }

    private void initIndexMaps() {
        if (this.masterAnnotations == null) {
            this.masterAnnotations = new HashMap<DotName, List<AnnotationTarget>>();
        }
        if (this.subclasses == null) {
            this.subclasses = new HashMap<DotName, List<ClassInfo>>();
        }
        if (this.classes == null) {
            this.classes = new HashMap<DotName, ClassInfo>();
        }
        if (this.names == null) {
            this.names = new HashMap<String, DotName>();
        }
    }

    private DotName convertToName(String name) {
        return this.convertToName(name, '.');
    }

    private DotName convertToName(String name, char delim) {
        DotName result = this.names.get(name);
        if (result != null) {
            return result;
        }
        int loc = name.lastIndexOf(delim);
        String local = this.intern(name.substring(loc + 1));
        DotName prefix = loc < 1 ? null : this.convertToName(this.intern(name.substring(0, loc)), delim);
        result = new DotName(prefix, local, true);
        this.names.put(name, result);
        return result;
    }

    private void processMethodInfo(DataInputStream data) throws IOException {
        int numMethods = data.readUnsignedShort();
        int i = 0;
        while (i < numMethods) {
            short flags = (short)data.readUnsignedShort();
            String name = this.intern(this.decodeUtf8Entry(data.readUnsignedShort()));
            String descriptor = this.decodeUtf8Entry(data.readUnsignedShort());
            IntegerHolder pos = new IntegerHolder();
            Type[] args = this.parseMethodArgs(descriptor, pos);
            IntegerHolder integerHolder = pos;
            integerHolder.i = integerHolder.i + 1;
            Type returnType = this.parseType(descriptor, pos);
            MethodInfo method = new MethodInfo(this.currentClass, name, args, returnType, flags);
            this.processAttributes(data, method);
            ++i;
        }
    }

    private void processFieldInfo(DataInputStream data) throws IOException {
        int numFields = data.readUnsignedShort();
        int i = 0;
        while (i < numFields) {
            short flags = (short)data.readUnsignedShort();
            String name = this.intern(this.decodeUtf8Entry(data.readUnsignedShort()));
            Type type = this.parseType(this.decodeUtf8Entry(data.readUnsignedShort()));
            FieldInfo field = new FieldInfo(this.currentClass, name, type, flags);
            this.processAttributes(data, field);
            ++i;
        }
    }

    private void processAttributes(DataInputStream data, AnnotationTarget target) throws IOException {
        int numAttrs = data.readUnsignedShort();
        int a = 0;
        while (a < numAttrs) {
            short s;
            int index = data.readUnsignedShort();
            long attributeLen = (long)data.readInt() & 0xFFFFFFFFL;
            byte annotationAttribute = this.constantPoolAnnoAttrributes[index - 1];
            if (annotationAttribute == 1) {
                s = data.readUnsignedShort();
                while (s-- > 0) {
                    this.processAnnotation(data, target);
                }
            } else if (annotationAttribute == 2) {
                if (!(target instanceof MethodInfo)) {
                    throw new IllegalStateException("RuntimeVisibleParameterAnnotaitons appeared on a non-method");
                }
                s = data.readUnsignedByte();
                short p = 0;
                while (p < s) {
                    int numAnnotations = data.readUnsignedShort();
                    while (numAnnotations-- > 0) {
                        this.processAnnotation(data, new MethodParameterInfo((MethodInfo)target, p));
                    }
                    p = (short)(p + 1);
                }
            } else {
                Indexer.skipFully(data, attributeLen);
            }
            ++a;
        }
    }

    private void processAnnotation(DataInputStream data, AnnotationTarget target) throws IOException {
        String annotation = Indexer.convertClassFieldDescriptor(this.decodeUtf8Entry(data.readUnsignedShort()));
        int valuePairs = data.readUnsignedShort();
        int v = 0;
        while (v < valuePairs) {
            data.skipBytes(2);
            this.processAnnotationElementValue(data);
            ++v;
        }
        if (target == null) {
            return;
        }
        DotName annotationName = this.convertToName(annotation);
        this.recordAnnotation(this.classAnnotations, annotationName, target);
        this.recordAnnotation(this.masterAnnotations, annotationName, target);
    }

    private void recordAnnotation(Map<DotName, List<AnnotationTarget>> classAnnotations2, DotName annotation, AnnotationTarget target) {
        List<AnnotationTarget> list = classAnnotations2.get(annotation);
        if (list == null) {
            list = new ArrayList<AnnotationTarget>();
            classAnnotations2.put(annotation, list);
        }
        list.add(target);
    }

    private String intern(String string) {
        return this.internPool.intern(string);
    }

    private void processAnnotationElementValue(DataInputStream data) throws IOException {
        int tag = data.readUnsignedByte();
        switch (tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 99: 
            case 115: {
                data.skipBytes(2);
                break;
            }
            case 101: {
                data.skipBytes(4);
                break;
            }
            case 64: {
                this.processAnnotation(data, null);
                break;
            }
            case 91: {
                int numValues = data.readUnsignedShort();
                int i = 0;
                while (i < numValues) {
                    this.processAnnotationElementValue(data);
                    ++i;
                }
                break;
            }
        }
    }

    private void processClassInfo(DataInputStream data) throws IOException {
        short flags = (short)data.readUnsignedShort();
        DotName thisName = this.decodeClassEntry(data.readUnsignedShort());
        int superIndex = data.readUnsignedShort();
        DotName superName = superIndex != 0 ? this.decodeClassEntry(superIndex) : null;
        int numInterfaces = data.readUnsignedShort();
        DotName[] interfaces = new DotName[numInterfaces];
        int i = 0;
        while (i < numInterfaces) {
            interfaces[i] = this.decodeClassEntry(data.readUnsignedShort());
            ++i;
        }
        this.classAnnotations = new HashMap();
        this.currentClass = new ClassInfo(thisName, superName, flags, interfaces, this.classAnnotations);
        if (superName != null) {
            this.addSubclass(superName, this.currentClass);
        }
        this.classes.put(this.currentClass.name(), this.currentClass);
    }

    private void addSubclass(DotName superName, ClassInfo currentClass) {
        List<ClassInfo> list = this.subclasses.get(superName);
        if (list == null) {
            list = new ArrayList<ClassInfo>();
            this.subclasses.put(superName, list);
        }
        list.add(currentClass);
    }

    private boolean isJDK5OrNewer(DataInputStream stream) throws IOException {
        byte[] buf = new byte[4];
        stream.readFully(buf);
        return buf[2] > 0 || buf[3] > 48;
    }

    private void verifyMagic(DataInputStream stream) throws IOException {
        byte[] buf = new byte[4];
        stream.readFully(buf);
        if (buf[0] != -54 || buf[1] != -2 || buf[2] != -70 || buf[3] != -66) {
            throw new RuntimeException("Invalid Magic");
        }
    }

    private DotName decodeClassEntry(int classInfoIndex) {
        byte[] pool = this.constantPool;
        int[] offsets = this.constantPoolOffsets;
        int pos = offsets[classInfoIndex - 1];
        if (pool[pos] != 7) {
            throw new IllegalStateException("Constant pool entry is not a class info type: " + classInfoIndex + ":" + pos);
        }
        int nameIndex = (pool[++pos] & 0xFF) << 8 | pool[++pos] & 0xFF;
        return this.convertToName(this.decodeUtf8Entry(nameIndex), '/');
    }

    private String decodeUtf8Entry(int index) {
        byte[] pool = this.constantPool;
        int[] offsets = this.constantPoolOffsets;
        int pos = offsets[index - 1];
        if (pool[pos] != 1) {
            throw new IllegalStateException("Constant pool entry is not a utf8 info type: " + index + ":" + pos);
        }
        int len = (pool[++pos] & 0xFF) << 8 | pool[++pos] & 0xFF;
        return new String(pool, ++pos, len, Charset.forName("UTF-8"));
    }

    private static String convertClassFieldDescriptor(String descriptor) {
        if (descriptor.charAt(0) != 'L') {
            throw new IllegalArgumentException("Non class descriptor: " + descriptor);
        }
        return descriptor.substring(1, descriptor.length() - 1).replace('/', '.');
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private Type[] parseMethodArgs(String descriptor, IntegerHolder pos) {
        ArrayList<Type> types;
        block4: {
            int n;
            IntegerHolder integerHolder;
            block3: {
                if (descriptor.charAt(pos.i) != '(') {
                    throw new IllegalArgumentException("Invalid descriptor: " + descriptor);
                }
                types = new ArrayList<Type>();
                if (!true) break block3;
                integerHolder = pos;
                n = integerHolder.i + 1;
                integerHolder.i = n;
                if (descriptor.charAt(n) == ')') break block4;
            }
            do {
                types.add(this.parseType(descriptor, pos));
                integerHolder = pos;
                n = integerHolder.i + 1;
                integerHolder.i = n;
            } while (descriptor.charAt(n) != ')');
        }
        return types.toArray(new Type[0]);
    }

    private Type parseType(String descriptor) {
        return this.parseType(descriptor, new IntegerHolder());
    }

    private Type parseType(String descriptor, IntegerHolder pos) {
        DotName name;
        int start = pos.i;
        char c = descriptor.charAt(start);
        Type.Kind kind = Type.Kind.PRIMITIVE;
        switch (c) {
            case 'B': {
                name = new DotName(null, "byte", true);
                break;
            }
            case 'C': {
                name = new DotName(null, "char", true);
                break;
            }
            case 'D': {
                name = new DotName(null, "double", true);
                break;
            }
            case 'F': {
                name = new DotName(null, "float", true);
                break;
            }
            case 'I': {
                name = new DotName(null, "int", true);
                break;
            }
            case 'J': {
                name = new DotName(null, "long", true);
                break;
            }
            case 'S': {
                name = new DotName(null, "short", true);
                break;
            }
            case 'Z': {
                name = new DotName(null, "boolean", true);
                break;
            }
            case 'V': {
                name = new DotName(null, "void", true);
                kind = Type.Kind.VOID;
                break;
            }
            case 'L': {
                int end = start;
                while (descriptor.charAt(++end) != ';') {
                }
                name = this.convertToName(descriptor.substring(start + 1, end), '/');
                kind = Type.Kind.CLASS;
                pos.i = end;
                break;
            }
            case '[': {
                int end = start;
                while (descriptor.charAt(++end) == '[') {
                }
                if (descriptor.charAt(end) == 'L') {
                    while (descriptor.charAt(++end) != ';') {
                    }
                }
                name = new DotName(null, descriptor.substring(start, end + 1), true);
                kind = Type.Kind.ARRAY;
                pos.i = end;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid descriptor: " + descriptor + " pos " + start);
            }
        }
        return new Type(name, kind);
    }

    private boolean processConstantPool(DataInputStream stream) throws IOException {
        int poolCount = stream.readUnsignedShort() - 1;
        byte[] buf = new byte[20 * poolCount];
        byte[] annoAttributes = new byte[poolCount];
        int[] offsets = new int[poolCount];
        boolean hasAnnotations = false;
        int pos = 0;
        int offset = 0;
        while (pos < poolCount) {
            int tag = stream.readUnsignedByte();
            offsets[pos] = offset;
            switch (tag) {
                case 7: 
                case 8: {
                    buf = Indexer.sizeToFit(buf, 3, offset, poolCount - pos);
                    buf[offset++] = (byte)tag;
                    stream.readFully(buf, offset, 2);
                    offset += 2;
                    break;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    buf = Indexer.sizeToFit(buf, 5, offset, poolCount - pos);
                    buf[offset++] = (byte)tag;
                    stream.readFully(buf, offset, 4);
                    offset += 4;
                    break;
                }
                case 5: 
                case 6: {
                    buf = Indexer.sizeToFit(buf, 9, offset, poolCount - pos);
                    buf[offset++] = (byte)tag;
                    stream.readFully(buf, offset, 8);
                    offset += 8;
                    ++pos;
                    break;
                }
                case 1: {
                    int len = stream.readUnsignedShort();
                    buf = Indexer.sizeToFit(buf, len + 3, offset, poolCount - pos);
                    buf[offset++] = (byte)tag;
                    buf[offset++] = (byte)(len >>> 8);
                    buf[offset++] = (byte)len;
                    stream.readFully(buf, offset, len);
                    if (len == RUNTIME_ANNOTATIONS_LEN && Indexer.match(buf, offset, RUNTIME_ANNOTATIONS)) {
                        annoAttributes[pos] = 1;
                        hasAnnotations = true;
                    } else if (len == RUNTIME_PARAM_ANNOTATIONS_LEN && Indexer.match(buf, offset, RUNTIME_PARAM_ANNOTATIONS)) {
                        annoAttributes[pos] = 2;
                        hasAnnotations = true;
                    }
                    offset += len;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown tag! pos=" + pos + " poolCount = " + poolCount);
                }
            }
            ++pos;
        }
        this.constantPool = buf;
        this.constantPoolOffsets = offsets;
        this.constantPoolAnnoAttrributes = annoAttributes;
        return hasAnnotations;
    }

    public ClassInfo index(InputStream stream) throws IOException {
        try {
            DataInputStream data = new DataInputStream(new BufferedInputStream(stream));
            this.verifyMagic(data);
            if (!this.isJDK5OrNewer(data)) {
                return null;
            }
            this.initIndexMaps();
            this.internPool = new StrongInternPool();
            boolean hasAnnotations = this.processConstantPool(data);
            this.processClassInfo(data);
            if (!hasAnnotations) {
                ClassInfo classInfo = this.currentClass;
                return classInfo;
            }
            this.processFieldInfo(data);
            this.processMethodInfo(data);
            this.processAttributes(data, this.currentClass);
            ClassInfo classInfo = this.publishClass = this.currentClass;
            return classInfo;
        }
        finally {
            this.constantPool = null;
            this.constantPoolOffsets = null;
            this.constantPoolAnnoAttrributes = null;
            this.currentClass = null;
            this.classAnnotations = null;
            this.internPool = null;
        }
    }

    public Index complete() {
        this.initIndexMaps();
        try {
            Index index = new Index(this.masterAnnotations, this.subclasses, this.classes);
            return index;
        }
        finally {
            this.masterAnnotations = null;
            this.subclasses = null;
            this.classes = null;
        }
    }

    private static class IntegerHolder {
        private int i;

        private IntegerHolder() {
        }
    }
}

