/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReaderImpl;
import org.jboss.jandex.IndexReaderV1;
import org.jboss.jandex.IndexReaderV2;
import org.jboss.jandex.PackedDataInputStream;
import org.jboss.jandex.UnsupportedVersion;

public final class IndexReader {
    private static final int MAGIC = -1161945323;
    private InputStream input;

    public IndexReader(InputStream input) {
        this.input = input;
    }

    public Index read() throws IOException {
        PackedDataInputStream stream = new PackedDataInputStream(new BufferedInputStream(this.input));
        if (stream.readInt() != -1161945323) {
            stream.close();
            throw new IllegalArgumentException("Not a jandex index");
        }
        byte version = stream.readByte();
        IndexReaderImpl reader = this.getReader(stream, version);
        if (reader == null) {
            stream.close();
            throw new UnsupportedVersion("Version: " + version);
        }
        return reader.read(version);
    }

    private IndexReaderImpl getReader(PackedDataInputStream stream, int version) {
        if (version >= 1 && version <= 3) {
            return new IndexReaderV1(stream);
        }
        if (version >= 6 && version <= 6) {
            return new IndexReaderV2(stream);
        }
        return null;
    }
}

