/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.stream;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.xml.stream.FactoryConfigurationError;

class FactoryLocator {
    private static final String JAVA_HOME = System.getProperty("java.home");
    private static final String PROPERTY_FILE = JAVA_HOME + File.pathSeparator + "lib" + File.pathSeparator + "xml.stream.properties";
    private static final String SERVICES_PATH = "META-INF/services/";

    FactoryLocator() {
    }

    private static Object newInstance(String className, ClassLoader classLoader) {
        try {
            return classLoader.loadClass(className).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new FactoryConfigurationError("Could not locate provider [" + className + "]", e);
        }
        catch (Exception e) {
            throw new FactoryConfigurationError("Error creating provider [" + className + "]", e);
        }
    }

    private static String getPropertyFromFile(String property) {
        File file = new File(PROPERTY_FILE);
        if (!file.exists()) {
            return null;
        }
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(file));
            return properties.getProperty(property);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String getPropertyFromServices(String property, ClassLoader classLoader) {
        String resource = SERVICES_PATH + property;
        InputStream stream = classLoader.getResourceAsStream(property);
        if (stream == null) {
            return null;
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            return reader.readLine();
        }
        catch (Exception e) {
            return null;
        }
    }

    static Object find(String factoryId, String defaultFactory) throws FactoryConfigurationError {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return FactoryLocator.find(factoryId, defaultFactory, loader);
    }

    static Object find(String factoryId, String defaultFactory, ClassLoader classLoader) throws FactoryConfigurationError {
        if (classLoader == null) {
            throw new FactoryConfigurationError("Could not determine classloader.");
        }
        String value = System.getProperty(factoryId);
        if (value != null) {
            return FactoryLocator.newInstance(value, classLoader);
        }
        value = FactoryLocator.getPropertyFromFile(factoryId);
        if (value != null) {
            return FactoryLocator.newInstance(value, classLoader);
        }
        value = FactoryLocator.getPropertyFromServices(factoryId, classLoader);
        if (value != null) {
            return FactoryLocator.newInstance(value, classLoader);
        }
        return FactoryLocator.newInstance(defaultFactory, classLoader);
    }
}

