/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dmr;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.ModelValue;
import org.jboss.dmr.Property;

final class PropertyModelValue
extends ModelValue {
    private final Property property;

    PropertyModelValue(String name, ModelNode value) {
        this(new Property(name, value));
    }

    PropertyModelValue(Property property) {
        super(ModelType.PROPERTY);
        this.property = property;
    }

    PropertyModelValue(DataInput in) throws IOException {
        super(ModelType.PROPERTY);
        ModelNode node = new ModelNode();
        String name = in.readUTF();
        node.readExternal(in);
        this.property = new Property(name, node);
    }

    PropertyModelValue(String key, ModelNode node, boolean copy) {
        this(new Property(key, node, copy));
    }

    @Override
    void writeExternal(DataOutput out) throws IOException {
        out.writeUTF(this.property.getName());
        this.property.getValue().writeExternal(out);
    }

    @Override
    ModelValue protect() {
        this.property.getValue().protect();
        return this;
    }

    @Override
    String asString() {
        return String.format("(%s => %s)", PropertyModelValue.quote(this.property.getName()), this.property.getValue());
    }

    @Override
    Property asProperty() {
        return this.property;
    }

    @Override
    List<Property> asPropertyList() {
        return Collections.singletonList(this.property);
    }

    @Override
    ModelNode asObject() {
        ModelNode node = new ModelNode();
        node.get(this.property.getName()).set(this.property.getValue());
        return node;
    }

    @Override
    Set<String> getKeys() {
        return Collections.singleton(this.property.getName());
    }

    @Override
    List<ModelNode> asList() {
        return Collections.singletonList(new ModelNode(this));
    }

    @Override
    ModelNode getChild(String name) {
        return this.property.getName().equals(name) ? this.property.getValue() : super.getChild(name);
    }

    @Override
    ModelNode getChild(int index) {
        return index == 0 ? this.property.getValue() : super.getChild(index);
    }

    @Override
    ModelValue copy() {
        return new PropertyModelValue(this.property.getName(), this.property.getValue());
    }

    @Override
    ModelValue resolve() {
        return new PropertyModelValue(this.property.getName(), this.property.getValue().resolve());
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof PropertyModelValue && this.equals((PropertyModelValue)other);
    }

    public boolean equals(PropertyModelValue other) {
        return this == other || other != null && other.property.getName().equals(this.property.getName()) && other.property.getValue().equals(this.property.getValue());
    }

    @Override
    public int hashCode() {
        return this.property.getName().hashCode() * 31 + this.property.getValue().hashCode();
    }

    @Override
    boolean has(String key) {
        return key.equals(this.property.getName());
    }

    @Override
    ModelNode requireChild(String name) throws NoSuchElementException {
        return this.property.getName().equals(name) ? this.property.getValue() : super.requireChild(name);
    }
}

