/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dmr;

import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.ModelValue;
import org.jboss.dmr.StringModelValue;

final class ExpressionValue
extends ModelValue {
    public static final String TYPE_KEY = "EXPRESSION_VALUE";
    private final String expressionString;
    private static final int INITIAL = 0;
    private static final int GOT_DOLLAR = 1;
    private static final int GOT_OPEN_BRACE = 2;
    private static final int RESOLVED = 3;
    private static final int DEFAULT = 4;

    ExpressionValue(String expressionString) {
        super(ModelType.EXPRESSION);
        if (expressionString == null) {
            throw new IllegalArgumentException("expressionString is null");
        }
        this.expressionString = expressionString;
    }

    @Override
    void writeExternal(DataOutput out) throws IOException {
        out.writeUTF(this.expressionString);
    }

    @Override
    String asString() {
        return this.expressionString;
    }

    @Override
    void format(StringBuilder builder, int indent, boolean multiLine) {
        builder.append("expression ").append(ExpressionValue.quote(this.expressionString));
    }

    @Override
    void formatAsJSON(StringBuilder builder, int indent, boolean multiLine) {
        builder.append('{');
        if (multiLine) {
            ExpressionValue.indent(builder.append('\n'), indent + 1);
        } else {
            builder.append(' ');
        }
        builder.append(ExpressionValue.jsonEscape(TYPE_KEY));
        builder.append(" : ");
        builder.append(ExpressionValue.jsonEscape(this.asString()));
        if (multiLine) {
            ExpressionValue.indent(builder.append('\n'), indent);
        } else {
            builder.append(' ');
        }
        builder.append('}');
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ExpressionValue && this.equals((ExpressionValue)other);
    }

    public boolean equals(ExpressionValue other) {
        return this == other || other != null && this.expressionString.equals(other.expressionString);
    }

    @Override
    public int hashCode() {
        return this.expressionString.hashCode();
    }

    @Override
    ModelValue resolve() {
        return new StringModelValue(ExpressionValue.replaceProperties(this.expressionString));
    }

    private static String replaceProperties(String value) {
        StringBuilder builder = new StringBuilder();
        int len = value.length();
        int state = 0;
        int start = -1;
        int nameStart = -1;
        int i = 0;
        while (i < len) {
            int ch = value.codePointAt(i);
            block0 : switch (state) {
                case 0: {
                    switch (ch) {
                        case 36: {
                            state = 1;
                            break block0;
                        }
                    }
                    builder.appendCodePoint(ch);
                    break;
                }
                case 1: {
                    switch (ch) {
                        case 36: {
                            builder.appendCodePoint(ch);
                            state = 0;
                            break block0;
                        }
                        case 123: {
                            nameStart = start = i + 1;
                            state = 2;
                            break block0;
                        }
                    }
                    builder.append('$').appendCodePoint(ch);
                    state = 0;
                    break;
                }
                case 2: {
                    switch (ch) {
                        case 44: 
                        case 58: 
                        case 125: {
                            String name = value.substring(nameStart, i).trim();
                            if ("/".equals(name)) {
                                builder.append(File.separator);
                                state = ch == 125 ? 0 : 3;
                                break block0;
                            }
                            if (":".equals(name)) {
                                builder.append(File.pathSeparator);
                                state = ch == 125 ? 0 : 3;
                                break block0;
                            }
                            String val = System.getProperty(name);
                            if (val != null) {
                                builder.append(val);
                                state = ch == 125 ? 0 : 3;
                                break block0;
                            }
                            if (ch == 44) {
                                nameStart = i + 1;
                                break block0;
                            }
                            if (ch == 58) {
                                start = i + 1;
                                state = 4;
                                break block0;
                            }
                            builder.append(value.substring(start - 2, i + 1));
                            state = 0;
                            break block0;
                        }
                    }
                    break;
                }
                case 3: {
                    if (ch != 125) break;
                    state = 0;
                    break;
                }
                case 4: {
                    if (ch != 125) break;
                    state = 0;
                    builder.append(value.substring(start, i));
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            i = value.offsetByCodePoints(i, 1);
        }
        switch (state) {
            case 1: {
                builder.append('$');
                break;
            }
            case 2: 
            case 4: {
                builder.append(value.substring(start - 2));
            }
        }
        return builder.toString();
    }
}

