/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.io.UnsupportedEncodingException;
import org.jboss.ejb.client.SessionID;

public final class NodeAssociatedSessionID
extends SessionID {
    private static final long serialVersionUID = -7306257085240447972L;
    private final transient boolean cluster;
    private final transient String nodeName;

    NodeAssociatedSessionID(byte[] encodedForm) {
        super(encodedForm);
        if (encodedForm[0] != 7) {
            throw NodeAssociatedSessionID.wrongFormat();
        }
        int encLen = encodedForm.length;
        int end = -1;
        for (int i = 1; i < encLen; ++i) {
            if (encodedForm[i] != 0) continue;
            end = i;
            break;
        }
        if (end == -1 || end == 2) {
            throw NodeAssociatedSessionID.wrongFormat();
        }
        try {
            this.nodeName = new String(encodedForm, 1, end, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw NodeAssociatedSessionID.wrongFormat();
        }
        if (encLen < end + 17) {
            throw NodeAssociatedSessionID.wrongFormat();
        }
        this.cluster = encodedForm[end + 1] != 0;
    }

    private static IllegalArgumentException wrongFormat() {
        return new IllegalArgumentException("Wrong session ID format");
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public boolean isCluster() {
        return this.cluster;
    }
}

