/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.Unmarshaller;

final class ProtocolV1ObjectTable
implements ObjectTable {
    static final ProtocolV1ObjectTable INSTANCE = new ProtocolV1ObjectTable();
    private static final Map<Object, ByteWriter> writers;
    private static final Object[] objects;

    ProtocolV1ObjectTable() {
    }

    public ObjectTable.Writer getObjectWriter(Object object) throws IOException {
        return writers.get(object);
    }

    public Object readObject(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        int idx = unmarshaller.readUnsignedByte();
        if (idx >= objects.length) {
            throw new InvalidObjectException("ObjectTable " + this.getClass().getName() + " cannot find an object for object index " + idx);
        }
        return objects[idx];
    }

    static {
        objects = new Object[]{"jboss.transaction.id"};
        IdentityHashMap<Object, ByteWriter> map = new IdentityHashMap<Object, ByteWriter>();
        int length = objects.length;
        for (int i = 0; i < length; ++i) {
            map.put(objects[i], new ByteWriter((byte)i));
        }
        writers = map;
    }

    static final class ByteWriter
    implements ObjectTable.Writer {
        final byte[] bytes;

        ByteWriter(byte ... bytes) {
            this.bytes = bytes;
        }

        public void writeObject(Marshaller marshaller, Object object) throws IOException {
            marshaller.write(this.bytes);
        }
    }
}

