/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.EJBReceiverInvocationContext;
import org.jboss.ejb.client.remoting.MethodInvocationResponseHandler;
import org.jboss.ejb.client.remoting.ModuleAvailabilityMessageHandler;
import org.jboss.ejb.client.remoting.ProtocolMessageHandler;
import org.jboss.ejb.client.remoting.RemotingConnectionEJBReceiver;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.MessageInputStream;

class ChannelAssociation {
    private static final Logger logger = Logger.getLogger(ChannelAssociation.class);
    private final RemotingConnectionEJBReceiver ejbReceiver;
    private final EJBReceiverContext ejbReceiverContext;
    private final Channel channel;
    private final byte protocolVersion;
    private final String marshallingType;
    private final AtomicInteger nextInvocationId = new AtomicInteger(0);
    private Map<Short, EJBReceiverInvocationContext> waitingInvocations = Collections.synchronizedMap(new HashMap());

    ChannelAssociation(RemotingConnectionEJBReceiver ejbReceiver, EJBReceiverContext ejbReceiverContext, Channel channel, byte protocolVersion, String marshallingType) {
        this.ejbReceiver = ejbReceiver;
        this.ejbReceiverContext = ejbReceiverContext;
        this.channel = channel;
        this.protocolVersion = protocolVersion;
        this.marshallingType = marshallingType;
        this.channel.receiveMessage((Channel.Receiver)new ResponseReceiver());
    }

    Channel getChannel() {
        return this.channel;
    }

    short getNextInvocationId() {
        return (short)this.nextInvocationId.getAndIncrement();
    }

    void receiveResponse(short invocationId, EJBReceiverInvocationContext ejbReceiverInvocationContext) {
        this.waitingInvocations.put(invocationId, ejbReceiverInvocationContext);
    }

    EJBReceiverInvocationContext getEJBReceiverInvocationContext(short invocationId) {
        return this.waitingInvocations.get(invocationId);
    }

    private ProtocolMessageHandler getProtocolMessageHandler(byte header) {
        switch (header) {
            case 8: {
                return new ModuleAvailabilityMessageHandler(this.ejbReceiver);
            }
            case 5: {
                return new MethodInvocationResponseHandler(this, this.marshallingType);
            }
        }
        return null;
    }

    private class ResponseReceiver
    implements Channel.Receiver {
        private ResponseReceiver() {
        }

        public void handleError(Channel channel, IOException error) {
        }

        public void handleEnd(Channel channel) {
        }

        public void handleMessage(Channel channel, MessageInputStream messageInputStream) {
            try {
                int header = messageInputStream.read();
                logger.info((Object)("Received message with header 0x" + Integer.toHexString(header)));
                ProtocolMessageHandler messageHandler = ChannelAssociation.this.getProtocolMessageHandler((byte)header);
                if (messageHandler == null) {
                    logger.warn((Object)("Unsupported message received with header 0x" + Integer.toHexString(header)));
                    return;
                }
                messageHandler.processMessage(messageInputStream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                channel.receiveMessage((Channel.Receiver)this);
            }
        }
    }
}

