/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import org.jboss.ejb.client.remoting.Marshaller;
import org.jboss.ejb.client.remoting.UnMarshaller;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.SimpleClassResolver;
import org.jboss.marshalling.Unmarshaller;

class MarshallerFactory {
    MarshallerFactory() {
    }

    public static Marshaller createMarshaller(String marshallerType) throws IOException {
        if ("river".equals(marshallerType)) {
            return new JBossMarshaller(marshallerType);
        }
        if ("java-serial".equals(marshallerType)) {
            return new JavaSerialMarshaller();
        }
        throw new IllegalArgumentException("Unknown marshaller type " + marshallerType);
    }

    public static UnMarshaller createUnMarshaller(String marshallerType) throws IOException {
        if ("river".equals(marshallerType)) {
            return new JBossUnMarshaller(marshallerType);
        }
        if ("java-serial".equals(marshallerType)) {
            return new JavaSerialUnMarshaller();
        }
        throw new IllegalArgumentException("Unknown marshaller type " + marshallerType);
    }

    private static class JavaSerialUnMarshaller
    implements UnMarshaller {
        private DataInput dataInput;
        private ClassLoader cl;

        private JavaSerialUnMarshaller() {
        }

        @Override
        public void start(DataInput input, ClassLoader classLoader) throws IOException {
            this.cl = classLoader;
            this.dataInput = input;
        }

        @Override
        public Object readObject() throws ClassNotFoundException, IOException {
            InputStream is = new InputStream(){

                @Override
                public int read() throws IOException {
                    try {
                        return JavaSerialUnMarshaller.this.dataInput.readByte();
                    }
                    catch (EOFException eof) {
                        return -1;
                    }
                }
            };
            ObjectInputStream objectInputStream = new ObjectInputStream(is){

                protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    String name = desc.getName();
                    try {
                        return Class.forName(name, false, JavaSerialUnMarshaller.this.cl);
                    }
                    catch (ClassNotFoundException e) {
                        return super.resolveClass(desc);
                    }
                }
            };
            return objectInputStream.readObject();
        }

        @Override
        public void finish() throws IOException {
            this.dataInput = null;
        }
    }

    private static class JavaSerialMarshaller
    implements Marshaller {
        private DataOutput dataOutput;

        private JavaSerialMarshaller() {
        }

        @Override
        public void start(DataOutput output) throws IOException {
            this.dataOutput = output;
        }

        @Override
        public void writeObject(Object object) throws IOException {
            OutputStream os = new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    JavaSerialMarshaller.this.dataOutput.write(b);
                }
            };
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(os);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
        }

        @Override
        public void finish() throws IOException {
            this.dataOutput = null;
        }
    }

    private static class JBossUnMarshaller
    implements UnMarshaller {
        private final String marshallerType;
        private Unmarshaller delegate;

        JBossUnMarshaller(String marshallerType) throws IOException {
            this.marshallerType = marshallerType;
        }

        @Override
        public void start(final DataInput input, ClassLoader classLoader) throws IOException {
            MarshallingConfiguration marshallingConfiguration = new MarshallingConfiguration();
            marshallingConfiguration.setVersion(2);
            marshallingConfiguration.setClassResolver((ClassResolver)new SimpleClassResolver(classLoader));
            org.jboss.marshalling.MarshallerFactory factory = Marshalling.getProvidedMarshallerFactory((String)this.marshallerType);
            this.delegate = factory.createUnmarshaller(marshallingConfiguration);
            InputStream is = new InputStream(){

                @Override
                public int read() throws IOException {
                    try {
                        return input.readByte();
                    }
                    catch (EOFException eof) {
                        return -1;
                    }
                }
            };
            ByteInput byteInput = Marshalling.createByteInput((InputStream)is);
            this.delegate.start(byteInput);
        }

        @Override
        public Object readObject() throws IOException, ClassNotFoundException {
            if (this.delegate == null) {
                throw new IllegalStateException("Unmarshalling hasn't yet been marked for start");
            }
            return this.delegate.readObject();
        }

        @Override
        public void finish() throws IOException {
            if (this.delegate == null) {
                throw new IllegalStateException("Unmarshalling hasn't yet been marked for start");
            }
            this.delegate.finish();
        }
    }

    private static class JBossMarshaller
    implements Marshaller {
        private final org.jboss.marshalling.Marshaller delegate;

        JBossMarshaller(String marshallerType) throws IOException {
            MarshallingConfiguration marshallingConfiguration = new MarshallingConfiguration();
            marshallingConfiguration.setVersion(2);
            org.jboss.marshalling.MarshallerFactory factory = Marshalling.getProvidedMarshallerFactory((String)marshallerType);
            this.delegate = factory.createMarshaller(marshallingConfiguration);
        }

        @Override
        public void start(final DataOutput output) throws IOException {
            ByteOutput byteOutput = new ByteOutput(){

                public void write(int b) throws IOException {
                    output.write(b);
                }

                public void write(byte[] b) throws IOException {
                    output.write(b);
                }

                public void write(byte[] b, int off, int len) throws IOException {
                    output.write(b, off, len);
                }

                public void close() throws IOException {
                }

                public void flush() throws IOException {
                }
            };
            this.delegate.start(byteOutput);
        }

        @Override
        public void writeObject(Object object) throws IOException {
            this.delegate.writeObject(object);
        }

        @Override
        public void finish() throws IOException {
            this.delegate.finish();
        }
    }
}

