/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.EJBReceiverInvocationContext;
import org.jboss.ejb.client.NoSessionID;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.remoting.ChannelAssociation;
import org.jboss.ejb.client.remoting.MethodInvocationMessageWriter;
import org.jboss.ejb.client.remoting.RemotingAttachments;
import org.jboss.ejb.client.remoting.VersionReceiver;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Connection;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

public final class RemotingConnectionEJBReceiver
extends EJBReceiver<RemotingAttachments> {
    private static final Logger logger = Logger.getLogger(RemotingConnectionEJBReceiver.class);
    private final Connection connection;
    private final Map<EJBReceiverContext, ChannelAssociation> channelAssociation = new IdentityHashMap<EJBReceiverContext, ChannelAssociation>();
    private final byte clientProtocolVersion = 0;
    private final String clientMarshallingStrategy = "river";

    public RemotingConnectionEJBReceiver(Connection connection) {
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void associate(EJBReceiverContext context) {
        block6: {
            CountDownLatch versionHandshakeLatch = new CountDownLatch(1);
            final VersionReceiver versionReceiver = new VersionReceiver(versionHandshakeLatch, this.clientProtocolVersion, this.clientMarshallingStrategy);
            IoFuture futureChannel = this.connection.openChannel("jboss.ejb", OptionMap.EMPTY);
            futureChannel.addNotifier((IoFuture.Notifier)new IoFuture.HandlingNotifier<Channel, EJBReceiverContext>(){

                public void handleCancelled(EJBReceiverContext context) {
                    context.close();
                }

                public void handleFailed(IOException exception, EJBReceiverContext context) {
                    context.close();
                }

                public void handleDone(Channel channel, final EJBReceiverContext context) {
                    channel.addCloseHandler((CloseHandler)new CloseHandler<Channel>(){

                        public void handleClose(Channel closed, IOException exception) {
                            context.close();
                        }
                    });
                    channel.receiveMessage((Channel.Receiver)versionReceiver);
                }
            }, (Object)context);
            try {
                boolean successfulHandshake = versionHandshakeLatch.await(5L, TimeUnit.SECONDS);
                if (successfulHandshake) {
                    Channel compatibleChannel = versionReceiver.getCompatibleChannel();
                    ChannelAssociation channelAssociation = new ChannelAssociation(this, context, compatibleChannel, this.clientProtocolVersion, this.clientMarshallingStrategy);
                    Map<EJBReceiverContext, ChannelAssociation> map = this.channelAssociation;
                    synchronized (map) {
                        this.channelAssociation.put(context, channelAssociation);
                    }
                    logger.info((Object)("Successful version handshake completed for receiver context " + context + " on channel " + compatibleChannel));
                    break block6;
                }
                logger.info((Object)("Version handshake not completed for recevier context " + context + " by receiver " + this + " . Closing the receiver context"));
                context.close();
            }
            catch (InterruptedException e) {
                context.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processInvocation(EJBClientInvocationContext<RemotingAttachments> clientInvocationContext, EJBReceiverInvocationContext ejbReceiverInvocationContext) throws Exception {
        ChannelAssociation channelAssociation;
        Map<EJBReceiverContext, ChannelAssociation> map = this.channelAssociation;
        synchronized (map) {
            channelAssociation = this.channelAssociation.get(ejbReceiverInvocationContext.getEjbReceiverContext());
        }
        if (channelAssociation == null) {
            throw new IllegalStateException("EJB receiver " + this + " is not yet ready to process invocations for receiver context " + ejbReceiverInvocationContext);
        }
        MethodInvocationMessageWriter messageWriter = new MethodInvocationMessageWriter(this, this.clientProtocolVersion, this.clientMarshallingStrategy);
        Channel channel = channelAssociation.getChannel();
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)channel.writeMessage());
        short invocationId = channelAssociation.getNextInvocationId();
        try {
            messageWriter.writeMessage(dataOutputStream, invocationId, clientInvocationContext);
        }
        finally {
            dataOutputStream.close();
        }
        channelAssociation.receiveResponse(invocationId, ejbReceiverInvocationContext);
    }

    @Override
    public SessionID openSession(EJBReceiverContext receiverContext, String appName, String moduleName, String distinctName, String beanName) throws Exception {
        return NoSessionID.INSTANCE;
    }

    @Override
    public void verify(String appName, String moduleName, String distinctName, String beanName) throws Exception {
    }

    @Override
    public RemotingAttachments createReceiverSpecific() {
        return new RemotingAttachments();
    }

    void onModuleAvailable(String appName, String moduleName, String distinctName) {
        logger.info((Object)("Received module availability message for appName: " + appName + " moduleName: " + moduleName + " distinctName: " + distinctName));
        this.registerModule(appName, moduleName, distinctName);
    }
}

