/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jboss.ejb.client.EJBHandle;
import org.jboss.ejb.client.EJBHomeHandle;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EntityEJBLocator;
import org.jboss.ejb.client.Locator;
import org.jboss.ejb.client.SerializedEJBInvocationHandler;
import org.jboss.ejb.client.StatefulEJBLocator;
import org.jboss.ejb.client.StatelessEJBLocator;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Unmarshaller;

final class ProtocolV1ClassTable
implements ClassTable {
    private static final Map<Class<?>, ByteWriter> writers;
    private static Class<?>[] classes;

    ProtocolV1ClassTable() {
    }

    public ClassTable.Writer getClassWriter(Class<?> clazz) throws IOException {
        return writers.get(clazz);
    }

    public Class<?> readClass(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        int idx = unmarshaller.readUnsignedByte();
        if (idx >= classes.length) {
            throw new ClassNotFoundException("ClassTable " + this.getClass().getName() + " cannot find a class for class index " + idx);
        }
        return classes[idx];
    }

    static {
        classes = new Class[]{Locator.class, EJBLocator.class, StatelessEJBLocator.class, StatefulEJBLocator.class, EntityEJBLocator.class, EJBHandle.class, EJBHomeHandle.class, SerializedEJBInvocationHandler.class};
        IdentityHashMap map = new IdentityHashMap();
        int length = classes.length;
        for (int i = 0; i < length; ++i) {
            map.put(classes[i], new ByteWriter((byte)i));
        }
        writers = map;
    }

    static final class ByteWriter
    implements ClassTable.Writer {
        final byte[] bytes;

        ByteWriter(byte ... bytes) {
            this.bytes = bytes;
        }

        public void writeClass(Marshaller marshaller, Class<?> clazz) throws IOException {
            marshaller.write(this.bytes);
        }
    }
}

