/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.transaction.xa.XAException;
import org.jboss.ejb.client.EJBClientInterceptor;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.EJBReceiverInvocationContext;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.TransactionID;
import org.jboss.ejb.client.remoting.ChannelAssociation;
import org.jboss.ejb.client.remoting.MethodInvocationMessageWriter;
import org.jboss.ejb.client.remoting.RemotingAttachments;
import org.jboss.ejb.client.remoting.RemotingEJBClientInterceptor;
import org.jboss.ejb.client.remoting.SessionOpenRequestWriter;
import org.jboss.ejb.client.remoting.TransactionMessageWriter;
import org.jboss.ejb.client.remoting.VersionReceiver;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Connection;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

public final class RemotingConnectionEJBReceiver
extends EJBReceiver<RemotingAttachments> {
    private static final Logger logger = Logger.getLogger(RemotingConnectionEJBReceiver.class);
    private static final String EJB_CHANNEL_NAME = "jboss.ejb";
    private static final RemotingEJBClientInterceptor[] REMOTING_EJB_INTERCEPTORS;
    private final Connection connection;
    private final Map<EJBReceiverContext, ChannelAssociation> channelAssociations = new IdentityHashMap<EJBReceiverContext, ChannelAssociation>();
    private final byte clientProtocolVersion = 1;
    private final String clientMarshallingStrategy = "river";

    public RemotingConnectionEJBReceiver(Connection connection) {
        this.connection = connection;
    }

    @Override
    protected EJBClientInterceptor<RemotingAttachments>[] getClientInterceptors() {
        return REMOTING_EJB_INTERCEPTORS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void associate(EJBReceiverContext context) {
        block6: {
            CountDownLatch versionHandshakeLatch = new CountDownLatch(1);
            final VersionReceiver versionReceiver = new VersionReceiver(versionHandshakeLatch, this.clientProtocolVersion, this.clientMarshallingStrategy);
            IoFuture futureChannel = this.connection.openChannel(EJB_CHANNEL_NAME, OptionMap.EMPTY);
            futureChannel.addNotifier((IoFuture.Notifier)new IoFuture.HandlingNotifier<Channel, EJBReceiverContext>(){

                public void handleCancelled(EJBReceiverContext context) {
                    logger.debug((Object)("Channel open requested cancelled for context " + context));
                    context.close();
                }

                public void handleFailed(IOException exception, EJBReceiverContext context) {
                    logger.error((Object)("Failed to open channel for context " + context), (Throwable)exception);
                    context.close();
                }

                public void handleDone(Channel channel, final EJBReceiverContext context) {
                    channel.addCloseHandler((CloseHandler)new CloseHandler<Channel>(){

                        public void handleClose(Channel closed, IOException exception) {
                            logger.debug((Object)("Closing channel" + closed), (Throwable)exception);
                            context.close();
                        }
                    });
                    logger.debug((Object)("Channel " + channel + " opened for context " + context + " Waiting for version handshake message from server"));
                    channel.receiveMessage((Channel.Receiver)versionReceiver);
                }
            }, (Object)context);
            try {
                boolean successfulHandshake = versionHandshakeLatch.await(5L, TimeUnit.SECONDS);
                if (successfulHandshake) {
                    Channel compatibleChannel = versionReceiver.getCompatibleChannel();
                    ChannelAssociation channelAssociation = new ChannelAssociation(this, context, compatibleChannel, this.clientProtocolVersion, this.clientMarshallingStrategy);
                    Map<EJBReceiverContext, ChannelAssociation> map = this.channelAssociations;
                    synchronized (map) {
                        this.channelAssociations.put(context, channelAssociation);
                    }
                    logger.info((Object)("Successful version handshake completed for receiver context " + context + " on channel " + compatibleChannel));
                    break block6;
                }
                logger.info((Object)("Version handshake not completed for recevier context " + context + " by receiver " + this + " . Closing the receiver context"));
                context.close();
            }
            catch (InterruptedException e) {
                context.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processInvocation(EJBClientInvocationContext<RemotingAttachments> clientInvocationContext, EJBReceiverInvocationContext ejbReceiverInvocationContext) throws Exception {
        ChannelAssociation channelAssociation = this.requireChannelAssociation(ejbReceiverInvocationContext.getEjbReceiverContext());
        Channel channel = channelAssociation.getChannel();
        MethodInvocationMessageWriter messageWriter = new MethodInvocationMessageWriter(this.clientProtocolVersion, this.clientMarshallingStrategy);
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)channel.writeMessage());
        short invocationId = channelAssociation.getNextInvocationId();
        channelAssociation.receiveResponse(invocationId, ejbReceiverInvocationContext);
        try {
            messageWriter.writeMessage(dataOutputStream, invocationId, clientInvocationContext);
        }
        finally {
            dataOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SessionID openSession(EJBReceiverContext receiverContext, String appName, String moduleName, String distinctName, String beanName) throws Exception {
        ChannelAssociation channelAssociation = this.requireChannelAssociation(receiverContext);
        Channel channel = channelAssociation.getChannel();
        SessionOpenRequestWriter sessionOpenRequestWriter = new SessionOpenRequestWriter(this.clientProtocolVersion, this.clientMarshallingStrategy);
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)channel.writeMessage());
        short invocationId = channelAssociation.getNextInvocationId();
        Future<EJBReceiverInvocationContext.ResultProducer> futureResultProducer = channelAssociation.receiveResponse(invocationId);
        try {
            sessionOpenRequestWriter.writeMessage(dataOutputStream, invocationId, appName, moduleName, distinctName, beanName, null);
        }
        finally {
            dataOutputStream.close();
        }
        EJBReceiverInvocationContext.ResultProducer resultProducer = futureResultProducer.get();
        SessionID sessionId = (SessionID)resultProducer.getResult();
        return sessionId;
    }

    @Override
    public void verify(String appName, String moduleName, String distinctName, String beanName) throws Exception {
        logger.warn((Object)"Not yet implemented RemotingConnectionEJBReceiver#verify");
    }

    @Override
    public RemotingAttachments createReceiverSpecific() {
        return new RemotingAttachments();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendCommit(EJBReceiverContext receiverContext, TransactionID transactionID, boolean onePhase) throws XAException {
        ChannelAssociation channelAssociation = this.requireChannelAssociation(receiverContext);
        short invocationId = channelAssociation.getNextInvocationId();
        Channel channel = channelAssociation.getChannel();
        Future<EJBReceiverInvocationContext.ResultProducer> futureResultProducer = channelAssociation.receiveResponse(invocationId);
        try {
            DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)channel.writeMessage());
            TransactionMessageWriter transactionMessageWriter = new TransactionMessageWriter();
            try {
                transactionMessageWriter.writeTxCommit(dataOutputStream, invocationId, transactionID);
            }
            finally {
                dataOutputStream.close();
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error sending transaction commit message", ioe);
        }
        try {
            EJBReceiverInvocationContext.ResultProducer resultProducer = futureResultProducer.get();
            resultProducer.getResult();
        }
        catch (XAException xae) {
            throw xae;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendRollback(EJBReceiverContext receiverContext, TransactionID transactionID) throws XAException {
        ChannelAssociation channelAssociation = this.requireChannelAssociation(receiverContext);
        short invocationId = channelAssociation.getNextInvocationId();
        Channel channel = channelAssociation.getChannel();
        Future<EJBReceiverInvocationContext.ResultProducer> futureResultProducer = channelAssociation.receiveResponse(invocationId);
        try {
            DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)channel.writeMessage());
            TransactionMessageWriter transactionMessageWriter = new TransactionMessageWriter();
            try {
                transactionMessageWriter.writeTxRollback(dataOutputStream, invocationId, transactionID);
            }
            finally {
                dataOutputStream.close();
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error sending transaction rollback message", ioe);
        }
        try {
            EJBReceiverInvocationContext.ResultProducer resultProducer = futureResultProducer.get();
            resultProducer.getResult();
        }
        catch (XAException xae) {
            throw xae;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void moduleAvailable(String appName, String moduleName, String distinctName) {
        logger.debug((Object)("Received module availability message for appName: " + appName + " moduleName: " + moduleName + " distinctName: " + distinctName));
        this.registerModule(appName, moduleName, distinctName);
    }

    void moduleUnavailable(String appName, String moduleName, String distinctName) {
        logger.debug((Object)("Received module un-availability message for appName: " + appName + " moduleName: " + moduleName + " distinctName: " + distinctName));
        this.deRegisterModule(appName, moduleName, distinctName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelAssociation requireChannelAssociation(EJBReceiverContext ejbReceiverContext) {
        ChannelAssociation channelAssociation;
        Map<EJBReceiverContext, ChannelAssociation> map = this.channelAssociations;
        synchronized (map) {
            channelAssociation = this.channelAssociations.get(ejbReceiverContext);
        }
        if (channelAssociation == null) {
            throw new IllegalStateException("EJB communication channel jboss.ejb is not yet ready to receive invocations (perhaps version handshake hasn't been completed), for receiver context " + ejbReceiverContext);
        }
        return channelAssociation;
    }

    static {
        ArrayList<RemotingEJBClientInterceptor> interceptors = new ArrayList<RemotingEJBClientInterceptor>();
        for (RemotingEJBClientInterceptor interceptor : ServiceLoader.load(RemotingEJBClientInterceptor.class)) {
            interceptors.add(interceptor);
        }
        REMOTING_EJB_INTERCEPTORS = interceptors.toArray(new RemotingEJBClientInterceptor[interceptors.size()]);
    }
}

